/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.config;

import java.util.Map;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.config.AbstractNestedConfigurer;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.restdocs.operation.preprocess.Preprocessors;

public abstract class OperationPreprocessorsConfigurer<PARENT, TYPE>
extends AbstractNestedConfigurer<PARENT> {
    private OperationRequestPreprocessor defaultOperationRequestPreprocessor;
    private OperationResponsePreprocessor defaultOperationResponsePreprocessor;

    protected OperationPreprocessorsConfigurer(PARENT parent) {
        super(parent);
    }

    @Override
    public void apply(Map<String, Object> configuration, RestDocumentationContext context) {
        configuration.put("org.springframework.restdocs.defaultOperationRequestPreprocessor", this.defaultOperationRequestPreprocessor);
        configuration.put("org.springframework.restdocs.defaultOperationResponsePreprocessor", this.defaultOperationResponsePreprocessor);
    }

    public TYPE withRequestDefaults(OperationPreprocessor ... preprocessors) {
        this.defaultOperationRequestPreprocessor = Preprocessors.preprocessRequest(preprocessors);
        return (TYPE)this;
    }

    public TYPE withResponseDefaults(OperationPreprocessor ... preprocessors) {
        this.defaultOperationResponsePreprocessor = Preprocessors.preprocessResponse(preprocessors);
        return (TYPE)this;
    }
}

