/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.constraints;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ConstraintResolver;

public class ValidatorConstraintResolver
implements ConstraintResolver {
    private final Validator validator;

    public ValidatorConstraintResolver() {
        this(Validation.buildDefaultValidatorFactory().getValidator());
    }

    public ValidatorConstraintResolver(Validator validator) {
        this.validator = validator;
    }

    @Override
    public List<Constraint> resolveForProperty(String property, Class<?> clazz) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(clazz);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(property);
        if (propertyDescriptor != null) {
            for (ConstraintDescriptor constraintDescriptor : propertyDescriptor.getConstraintDescriptors()) {
                constraints.add(new Constraint(constraintDescriptor.getAnnotation().annotationType().getName(), constraintDescriptor.getAttributes()));
            }
        }
        return constraints;
    }
}

