/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.headers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.headers.HeaderDescriptor;
import org.springframework.restdocs.headers.RequestHeadersSnippet;
import org.springframework.restdocs.headers.ResponseHeadersSnippet;

public abstract class HeaderDocumentation {
    private HeaderDocumentation() {
    }

    public static HeaderDescriptor headerWithName(String name) {
        return new HeaderDescriptor(name);
    }

    public static RequestHeadersSnippet requestHeaders(HeaderDescriptor ... descriptors) {
        return HeaderDocumentation.requestHeaders(Arrays.asList(descriptors));
    }

    public static RequestHeadersSnippet requestHeaders(List<HeaderDescriptor> descriptors) {
        return new RequestHeadersSnippet(descriptors);
    }

    public static RequestHeadersSnippet requestHeaders(Map<String, Object> attributes, HeaderDescriptor ... descriptors) {
        return HeaderDocumentation.requestHeaders(attributes, Arrays.asList(descriptors));
    }

    public static RequestHeadersSnippet requestHeaders(Map<String, Object> attributes, List<HeaderDescriptor> descriptors) {
        return new RequestHeadersSnippet(descriptors, attributes);
    }

    public static ResponseHeadersSnippet responseHeaders(HeaderDescriptor ... descriptors) {
        return HeaderDocumentation.responseHeaders(Arrays.asList(descriptors));
    }

    public static ResponseHeadersSnippet responseHeaders(List<HeaderDescriptor> descriptors) {
        return new ResponseHeadersSnippet(descriptors);
    }

    public static ResponseHeadersSnippet responseHeaders(Map<String, Object> attributes, HeaderDescriptor ... descriptors) {
        return HeaderDocumentation.responseHeaders(attributes, Arrays.asList(descriptors));
    }

    public static ResponseHeadersSnippet responseHeaders(Map<String, Object> attributes, List<HeaderDescriptor> descriptors) {
        return new ResponseHeadersSnippet(descriptors, attributes);
    }
}

