/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.hypermedia;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.hypermedia.AtomLinkExtractor;
import org.springframework.restdocs.hypermedia.ContentTypeLinkExtractor;
import org.springframework.restdocs.hypermedia.HalLinkExtractor;
import org.springframework.restdocs.hypermedia.LinkDescriptor;
import org.springframework.restdocs.hypermedia.LinkExtractor;
import org.springframework.restdocs.hypermedia.LinksSnippet;

public abstract class HypermediaDocumentation {
    private HypermediaDocumentation() {
    }

    public static LinkDescriptor linkWithRel(String rel) {
        return new LinkDescriptor(rel);
    }

    public static LinksSnippet links(LinkDescriptor ... descriptors) {
        return HypermediaDocumentation.links(Arrays.asList(descriptors));
    }

    public static LinksSnippet links(List<LinkDescriptor> descriptors) {
        return new LinksSnippet(new ContentTypeLinkExtractor(), descriptors);
    }

    public static LinksSnippet relaxedLinks(LinkDescriptor ... descriptors) {
        return HypermediaDocumentation.relaxedLinks(Arrays.asList(descriptors));
    }

    public static LinksSnippet relaxedLinks(List<LinkDescriptor> descriptors) {
        return new LinksSnippet((LinkExtractor)new ContentTypeLinkExtractor(), descriptors, true);
    }

    public static LinksSnippet links(Map<String, Object> attributes, LinkDescriptor ... descriptors) {
        return HypermediaDocumentation.links(attributes, Arrays.asList(descriptors));
    }

    public static LinksSnippet links(Map<String, Object> attributes, List<LinkDescriptor> descriptors) {
        return new LinksSnippet((LinkExtractor)new ContentTypeLinkExtractor(), descriptors, attributes);
    }

    public static LinksSnippet relaxedLinks(Map<String, Object> attributes, LinkDescriptor ... descriptors) {
        return HypermediaDocumentation.relaxedLinks(attributes, Arrays.asList(descriptors));
    }

    public static LinksSnippet relaxedLinks(Map<String, Object> attributes, List<LinkDescriptor> descriptors) {
        return new LinksSnippet(new ContentTypeLinkExtractor(), descriptors, attributes, true);
    }

    public static LinksSnippet links(LinkExtractor linkExtractor, LinkDescriptor ... descriptors) {
        return HypermediaDocumentation.links(linkExtractor, Arrays.asList(descriptors));
    }

    public static LinksSnippet links(LinkExtractor linkExtractor, List<LinkDescriptor> descriptors) {
        return new LinksSnippet(linkExtractor, descriptors);
    }

    public static LinksSnippet relaxedLinks(LinkExtractor linkExtractor, LinkDescriptor ... descriptors) {
        return HypermediaDocumentation.relaxedLinks(linkExtractor, Arrays.asList(descriptors));
    }

    public static LinksSnippet relaxedLinks(LinkExtractor linkExtractor, List<LinkDescriptor> descriptors) {
        return new LinksSnippet(linkExtractor, descriptors, true);
    }

    public static LinksSnippet links(LinkExtractor linkExtractor, Map<String, Object> attributes, LinkDescriptor ... descriptors) {
        return HypermediaDocumentation.links(linkExtractor, attributes, Arrays.asList(descriptors));
    }

    public static LinksSnippet links(LinkExtractor linkExtractor, Map<String, Object> attributes, List<LinkDescriptor> descriptors) {
        return new LinksSnippet(linkExtractor, descriptors, attributes);
    }

    public static LinksSnippet relaxedLinks(LinkExtractor linkExtractor, Map<String, Object> attributes, LinkDescriptor ... descriptors) {
        return HypermediaDocumentation.relaxedLinks(linkExtractor, attributes, Arrays.asList(descriptors));
    }

    public static LinksSnippet relaxedLinks(LinkExtractor linkExtractor, Map<String, Object> attributes, List<LinkDescriptor> descriptors) {
        return new LinksSnippet(linkExtractor, descriptors, attributes, true);
    }

    public static LinkExtractor halLinks() {
        return new HalLinkExtractor();
    }

    public static LinkExtractor atomLinks() {
        return new AtomLinkExtractor();
    }
}

