/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mustache;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.springframework.restdocs.mustache.Mustache;
import org.springframework.restdocs.mustache.Template;

public abstract class BasicCollector
implements Mustache.Collector {
    protected static final Mustache.VariableFetcher MAP_FETCHER = new Mustache.VariableFetcher(){

        @Override
        public Object get(Object ctx, String name) throws Exception {
            Map map = (Map)ctx;
            return map.containsKey(name) ? map.get(name) : Template.NO_FETCHER_FOUND;
        }
    };
    protected static final Mustache.VariableFetcher LIST_FETCHER = new Mustache.VariableFetcher(){

        @Override
        public Object get(Object ctx, String name) throws Exception {
            try {
                return ((List)ctx).get(Integer.parseInt(name));
            }
            catch (NumberFormatException nfe) {
                return Template.NO_FETCHER_FOUND;
            }
            catch (IndexOutOfBoundsException e) {
                return Template.NO_FETCHER_FOUND;
            }
        }
    };
    protected static final Mustache.VariableFetcher ITER_FETCHER = new Mustache.VariableFetcher(){

        @Override
        public Object get(Object ctx, String name) throws Exception {
            try {
                Iterator iter = (Iterator)ctx;
                int ll = Integer.parseInt(name);
                for (int ii = 0; ii < ll; ++ii) {
                    iter.next();
                }
                return iter.next();
            }
            catch (NumberFormatException nfe) {
                return Template.NO_FETCHER_FOUND;
            }
            catch (NoSuchElementException e) {
                return Template.NO_FETCHER_FOUND;
            }
        }
    };
    protected static final Mustache.VariableFetcher THIS_FETCHER = new Mustache.VariableFetcher(){

        @Override
        public Object get(Object ctx, String name) throws Exception {
            return ctx;
        }
    };
    protected static final ArrayHelper OBJECT_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return ((Object[])ctx)[index];
        }

        @Override
        public int length(Object ctx) {
            return ((Object[])ctx).length;
        }
    };
    protected static final ArrayHelper BOOLEAN_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return ((boolean[])ctx)[index];
        }

        @Override
        public int length(Object ctx) {
            return ((boolean[])ctx).length;
        }
    };
    protected static final ArrayHelper BYTE_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return ((byte[])ctx)[index];
        }

        @Override
        public int length(Object ctx) {
            return ((byte[])ctx).length;
        }
    };
    protected static final ArrayHelper CHAR_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return Character.valueOf(((char[])ctx)[index]);
        }

        @Override
        public int length(Object ctx) {
            return ((char[])ctx).length;
        }
    };
    protected static final ArrayHelper SHORT_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return ((short[])ctx)[index];
        }

        @Override
        public int length(Object ctx) {
            return ((short[])ctx).length;
        }
    };
    protected static final ArrayHelper INT_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return ((int[])ctx)[index];
        }

        @Override
        public int length(Object ctx) {
            return ((int[])ctx).length;
        }
    };
    protected static final ArrayHelper LONG_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return ((long[])ctx)[index];
        }

        @Override
        public int length(Object ctx) {
            return ((long[])ctx).length;
        }
    };
    protected static final ArrayHelper FLOAT_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return Float.valueOf(((float[])ctx)[index]);
        }

        @Override
        public int length(Object ctx) {
            return ((float[])ctx).length;
        }
    };
    protected static final ArrayHelper DOUBLE_ARRAY_HELPER = new ArrayHelper(){

        @Override
        protected Object get(Object ctx, int index) {
            return ((double[])ctx)[index];
        }

        @Override
        public int length(Object ctx) {
            return ((double[])ctx).length;
        }
    };

    @Override
    public Iterator<?> toIterator(final Object value) {
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value.getClass().isArray()) {
            final ArrayHelper helper = BasicCollector.arrayHelper(value);
            return new Iterator<Object>(){
                private int _count;
                private int _idx;
                {
                    this._count = helper.length(value);
                }

                @Override
                public boolean hasNext() {
                    return this._idx < this._count;
                }

                @Override
                public Object next() {
                    return helper.get(value, this._idx++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    @Override
    public Mustache.VariableFetcher createFetcher(Object ctx, String name) {
        if (name == Template.DOT_NAME || name == Template.THIS_NAME) {
            return THIS_FETCHER;
        }
        if (ctx instanceof Map) {
            return MAP_FETCHER;
        }
        char c = name.charAt(0);
        if (c >= '0' && c <= '9') {
            if (ctx instanceof List) {
                return LIST_FETCHER;
            }
            if (ctx instanceof Iterator) {
                return ITER_FETCHER;
            }
            if (ctx.getClass().isArray()) {
                return BasicCollector.arrayHelper(ctx);
            }
        }
        return null;
    }

    @Override
    public abstract <K, V> Map<K, V> createFetcherCache();

    protected static ArrayHelper arrayHelper(Object ctx) {
        if (ctx instanceof Object[]) {
            return OBJECT_ARRAY_HELPER;
        }
        if (ctx instanceof boolean[]) {
            return BOOLEAN_ARRAY_HELPER;
        }
        if (ctx instanceof byte[]) {
            return BYTE_ARRAY_HELPER;
        }
        if (ctx instanceof char[]) {
            return CHAR_ARRAY_HELPER;
        }
        if (ctx instanceof short[]) {
            return SHORT_ARRAY_HELPER;
        }
        if (ctx instanceof int[]) {
            return INT_ARRAY_HELPER;
        }
        if (ctx instanceof long[]) {
            return LONG_ARRAY_HELPER;
        }
        if (ctx instanceof float[]) {
            return FLOAT_ARRAY_HELPER;
        }
        if (ctx instanceof double[]) {
            return DOUBLE_ARRAY_HELPER;
        }
        return null;
    }

    protected static abstract class ArrayHelper
    implements Mustache.VariableFetcher {
        protected ArrayHelper() {
        }

        @Override
        public Object get(Object ctx, String name) throws Exception {
            try {
                return this.get(ctx, Integer.parseInt(name));
            }
            catch (NumberFormatException nfe) {
                return Template.NO_FETCHER_FOUND;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return Template.NO_FETCHER_FOUND;
            }
        }

        public abstract int length(Object var1);

        protected abstract Object get(Object var1, int var2);
    }
}

