/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.restdocs.operation.HttpHeadersHelper;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.StandardOperationResponse;

public class OperationResponseFactory {
    public OperationResponse create(HttpStatus status, HttpHeaders headers, byte[] content) {
        return new StandardOperationResponse(status, this.augmentHeaders(headers, content), content);
    }

    public OperationResponse createFrom(OperationResponse original, byte[] newContent) {
        return new StandardOperationResponse(original.getStatus(), this.getUpdatedHeaders(original.getHeaders(), newContent), newContent);
    }

    public OperationResponse createFrom(OperationResponse original, HttpHeaders newHeaders) {
        return new StandardOperationResponse(original.getStatus(), newHeaders, original.getContent());
    }

    private HttpHeaders augmentHeaders(HttpHeaders originalHeaders, byte[] content) {
        return new HttpHeadersHelper(originalHeaders).setContentLengthHeader(content).getHeaders();
    }

    private HttpHeaders getUpdatedHeaders(HttpHeaders originalHeaders, byte[] updatedContent) {
        return new HttpHeadersHelper(originalHeaders).updateContentLengthHeaderIfPresent(updatedContent).getHeaders();
    }
}

