/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.preprocess.ContentModifier;

class PatternReplacingContentModifier
implements ContentModifier {
    private final Pattern pattern;
    private final String replacement;

    PatternReplacingContentModifier(Pattern pattern, String replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    public byte[] modifyContent(byte[] content, MediaType contentType) {
        String original = contentType != null && contentType.getCharset() != null ? new String(content, contentType.getCharset()) : new String(content);
        Matcher matcher = this.pattern.matcher(original);
        StringBuilder builder = new StringBuilder();
        int previous = 0;
        while (matcher.find()) {
            String prefix;
            if (matcher.groupCount() > 0) {
                prefix = original.substring(previous, matcher.start(1));
                previous = matcher.end(1);
            } else {
                prefix = original.substring(previous, matcher.start());
                previous = matcher.end();
            }
            builder.append(prefix);
            builder.append(this.replacement);
        }
        if (previous < original.length()) {
            builder.append(original.substring(previous));
        }
        return builder.toString().getBytes();
    }
}

