/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.io.IOException;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.payload.AbstractBodySnippet;
import org.springframework.restdocs.payload.PayloadSubsectionExtractor;
import org.springframework.restdocs.snippet.SnippetException;

public class RequestPartBodySnippet
extends AbstractBodySnippet {
    private final String partName;

    public RequestPartBodySnippet(String partName) {
        this(partName, (PayloadSubsectionExtractor<?>)null, (Map<String, Object>)null);
    }

    public RequestPartBodySnippet(String partName, PayloadSubsectionExtractor<?> subsectionExtractor) {
        this(partName, subsectionExtractor, null);
    }

    public RequestPartBodySnippet(String partName, Map<String, Object> attributes) {
        this(partName, (PayloadSubsectionExtractor<?>)null, attributes);
    }

    public RequestPartBodySnippet(String partName, PayloadSubsectionExtractor<?> subsectionExtractor, Map<String, Object> attributes) {
        super("request-part-" + partName, "request-part", subsectionExtractor, attributes);
        this.partName = partName;
    }

    @Override
    protected byte[] getContent(Operation operation) throws IOException {
        return this.findPart(operation).getContent();
    }

    @Override
    protected MediaType getContentType(Operation operation) {
        return this.findPart(operation).getHeaders().getContentType();
    }

    private OperationRequestPart findPart(Operation operation) {
        for (OperationRequestPart candidate : operation.getRequest().getParts()) {
            if (!candidate.getName().equals(this.partName)) continue;
            return candidate;
        }
        throw new SnippetException("A request part named '" + this.partName + "' was not found in the request");
    }
}

