/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;

public abstract class AbstractParametersSnippet
extends TemplatedSnippet {
    private final Map<String, ParameterDescriptor> descriptorsByName = new LinkedHashMap<String, ParameterDescriptor>();
    private final boolean ignoreUndocumentedParameters;

    protected AbstractParametersSnippet(String snippetName, List<ParameterDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedParameters) {
        super(snippetName, attributes);
        for (ParameterDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getName(), (String)"Parameter descriptors must have a name");
            if (!descriptor.isIgnored()) {
                Assert.notNull((Object)descriptor.getDescription(), (String)("The descriptor for parameter '" + descriptor.getName() + "' must either have a description or be marked as ignored"));
            }
            this.descriptorsByName.put(descriptor.getName(), descriptor);
        }
        this.ignoreUndocumentedParameters = ignoreUndocumentedParameters;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        this.verifyParameterDescriptors(operation);
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, ParameterDescriptor> entry : this.descriptorsByName.entrySet()) {
            ParameterDescriptor descriptor = entry.getValue();
            if (descriptor.isIgnored()) continue;
            parameters.add(this.createModelForDescriptor(descriptor));
        }
        model.put("parameters", parameters);
        return model;
    }

    private void verifyParameterDescriptors(Operation operation) {
        Set<String> undocumentedParameters;
        Set<String> actualParameters = this.extractActualParameters(operation);
        HashSet<String> expectedParameters = new HashSet<String>();
        for (Map.Entry<String, ParameterDescriptor> entry : this.descriptorsByName.entrySet()) {
            if (entry.getValue().isOptional()) continue;
            expectedParameters.add(entry.getKey());
        }
        if (this.ignoreUndocumentedParameters) {
            undocumentedParameters = Collections.emptySet();
        } else {
            undocumentedParameters = new HashSet<String>(actualParameters);
            undocumentedParameters.removeAll(this.descriptorsByName.keySet());
        }
        HashSet<String> missingParameters = new HashSet<String>(expectedParameters);
        missingParameters.removeAll(actualParameters);
        if (!undocumentedParameters.isEmpty() || !missingParameters.isEmpty()) {
            this.verificationFailed(undocumentedParameters, missingParameters);
        }
    }

    protected abstract Set<String> extractActualParameters(Operation var1);

    protected abstract void verificationFailed(Set<String> var1, Set<String> var2);

    protected final Map<String, ParameterDescriptor> getParameterDescriptors() {
        return this.descriptorsByName;
    }

    protected Map<String, Object> createModelForDescriptor(ParameterDescriptor descriptor) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("name", descriptor.getName());
        model.put("description", descriptor.getDescription());
        model.put("optional", descriptor.isOptional());
        model.putAll(descriptor.getAttributes());
        return model;
    }
}

