/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.util.PropertyPlaceholderHelper;

public class RestDocumentationContextPlaceholderResolver
implements PropertyPlaceholderHelper.PlaceholderResolver {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([A-Z])");
    private final RestDocumentationContext context;

    public RestDocumentationContextPlaceholderResolver(RestDocumentationContext context) {
        this.context = context;
    }

    public String resolvePlaceholder(String placeholderName) {
        if ("step".equals(placeholderName)) {
            return Integer.toString(this.context.getStepCount());
        }
        String converted = this.tryMethodNameConversion(placeholderName);
        if (converted != null) {
            return converted;
        }
        return this.tryClassNameConversion(placeholderName);
    }

    private String tryMethodNameConversion(String placeholderName) {
        if ("methodName".equals(placeholderName)) {
            return this.context.getTestMethodName();
        }
        if ("method-name".equals(placeholderName)) {
            return this.camelCaseToKebabCase(this.context.getTestMethodName());
        }
        if ("method_name".equals(placeholderName)) {
            return this.camelCaseToSnakeCase(this.context.getTestMethodName());
        }
        return null;
    }

    private String tryClassNameConversion(String placeholderName) {
        if ("ClassName".equals(placeholderName)) {
            return this.context.getTestClass().getSimpleName();
        }
        if ("class-name".equals(placeholderName)) {
            return this.camelCaseToKebabCase(this.context.getTestClass().getSimpleName());
        }
        if ("class_name".equals(placeholderName)) {
            return this.camelCaseToSnakeCase(this.context.getTestClass().getSimpleName());
        }
        return null;
    }

    protected final String camelCaseToKebabCase(String string) {
        return this.camelCaseToSeparator(string, "-");
    }

    protected final String camelCaseToSnakeCase(String string) {
        return this.camelCaseToSeparator(string, "_");
    }

    protected final RestDocumentationContext getContext() {
        return this.context;
    }

    private String camelCaseToSeparator(String string, String separator) {
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(string);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement = matcher.start() > 0 ? separator + matcher.group(1).toLowerCase() : matcher.group(1).toLowerCase();
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

