/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.templates;

import org.springframework.restdocs.templates.TemplateFormat;

public abstract class TemplateFormats {
    private static final TemplateFormat ASCIIDOCTOR = new AsciidoctorTemplateFormat();
    private static final TemplateFormat MARKDOWN = new MarkdownTemplateFormat();

    private TemplateFormats() {
    }

    public static TemplateFormat asciidoctor() {
        return ASCIIDOCTOR;
    }

    public static TemplateFormat markdown() {
        return MARKDOWN;
    }

    private static final class MarkdownTemplateFormat
    extends AbstractTemplateFormat {
        private MarkdownTemplateFormat() {
            super("markdown", "md");
        }
    }

    private static final class AsciidoctorTemplateFormat
    extends AbstractTemplateFormat {
        private AsciidoctorTemplateFormat() {
            super("asciidoctor", "adoc");
        }
    }

    private static abstract class AbstractTemplateFormat
    implements TemplateFormat {
        private final String name;
        private final String fileExtension;

        private AbstractTemplateFormat(String name, String fileExtension) {
            this.name = name;
            this.fileExtension = fileExtension;
        }

        @Override
        public String getId() {
            return this.name;
        }

        @Override
        public String getFileExtension() {
            return this.fileExtension;
        }
    }
}

