/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.jwk;

import java.util.Collection;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkDefinitionSource;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkException;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkVerifyingJwtAccessTokenConverter;
import org.springframework.util.Assert;

public final class JwkTokenStore
implements TokenStore {
    private final JwtTokenStore delegate;

    public JwkTokenStore(String jwkSetUrl) {
        Assert.hasText((String)jwkSetUrl, (String)"jwkSetUrl cannot be empty");
        JwkDefinitionSource jwkDefinitionSource = new JwkDefinitionSource(jwkSetUrl);
        JwkVerifyingJwtAccessTokenConverter accessTokenConverter = new JwkVerifyingJwtAccessTokenConverter(jwkDefinitionSource);
        this.delegate = new JwtTokenStore(accessTokenConverter);
    }

    @Override
    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.delegate.readAuthentication(token);
    }

    @Override
    public OAuth2Authentication readAuthentication(String tokenValue) {
        return this.delegate.readAuthentication(tokenValue);
    }

    @Override
    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        throw this.operationNotSupported();
    }

    @Override
    public OAuth2AccessToken readAccessToken(String tokenValue) {
        return this.delegate.readAccessToken(tokenValue);
    }

    @Override
    public void removeAccessToken(OAuth2AccessToken token) {
        this.delegate.removeAccessToken(token);
    }

    @Override
    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        throw this.operationNotSupported();
    }

    @Override
    public OAuth2RefreshToken readRefreshToken(String tokenValue) {
        throw this.operationNotSupported();
    }

    @Override
    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken token) {
        throw this.operationNotSupported();
    }

    @Override
    public void removeRefreshToken(OAuth2RefreshToken token) {
        throw this.operationNotSupported();
    }

    @Override
    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken refreshToken) {
        throw this.operationNotSupported();
    }

    @Override
    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        throw this.operationNotSupported();
    }

    @Override
    public Collection<OAuth2AccessToken> findTokensByClientIdAndUserName(String clientId, String userName) {
        throw this.operationNotSupported();
    }

    @Override
    public Collection<OAuth2AccessToken> findTokensByClientId(String clientId) {
        throw this.operationNotSupported();
    }

    private JwkException operationNotSupported() {
        return new JwkException("This operation is not supported.");
    }
}

