/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Deprecated
public class DefaultRedirectResolver
implements RedirectResolver {
    private Collection<String> redirectGrantTypes = Arrays.asList("implicit", "authorization_code");
    private boolean matchSubdomains = false;
    private boolean matchPorts = true;

    public void setMatchSubdomains(boolean matchSubdomains) {
        this.matchSubdomains = matchSubdomains;
    }

    public void setMatchPorts(boolean matchPorts) {
        this.matchPorts = matchPorts;
    }

    public void setRedirectGrantTypes(Collection<String> redirectGrantTypes) {
        this.redirectGrantTypes = new HashSet<String>(redirectGrantTypes);
    }

    @Override
    public String resolveRedirect(String requestedRedirect, ClientDetails client) throws OAuth2Exception {
        Set<String> authorizedGrantTypes = client.getAuthorizedGrantTypes();
        if (authorizedGrantTypes.isEmpty()) {
            throw new InvalidGrantException("A client must have at least one authorized grant type.");
        }
        if (!this.containsRedirectGrantType(authorizedGrantTypes)) {
            throw new InvalidGrantException("A redirect_uri can only be used by implicit or authorization_code grant types.");
        }
        Set<String> registeredRedirectUris = client.getRegisteredRedirectUri();
        if (registeredRedirectUris == null || registeredRedirectUris.isEmpty()) {
            throw new InvalidRequestException("At least one redirect_uri must be registered with the client.");
        }
        return this.obtainMatchingRedirect(registeredRedirectUris, requestedRedirect);
    }

    private boolean containsRedirectGrantType(Set<String> grantTypes) {
        for (String type : grantTypes) {
            if (!this.redirectGrantTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    protected boolean redirectMatches(String requestedRedirect, String redirectUri) {
        UriComponents requestedRedirectUri = UriComponentsBuilder.fromUriString((String)requestedRedirect).build();
        UriComponents registeredRedirectUri = UriComponentsBuilder.fromUriString((String)redirectUri).build();
        boolean schemeMatch = this.isEqual(registeredRedirectUri.getScheme(), requestedRedirectUri.getScheme());
        boolean userInfoMatch = this.isEqual(registeredRedirectUri.getUserInfo(), requestedRedirectUri.getUserInfo());
        boolean hostMatch = this.hostMatches(registeredRedirectUri.getHost(), requestedRedirectUri.getHost());
        boolean portMatch = this.matchPorts ? registeredRedirectUri.getPort() == requestedRedirectUri.getPort() : true;
        boolean pathMatch = this.isEqual(registeredRedirectUri.getPath(), StringUtils.cleanPath((String)requestedRedirectUri.getPath()));
        boolean queryParamMatch = this.matchQueryParams((MultiValueMap<String, String>)registeredRedirectUri.getQueryParams(), (MultiValueMap<String, String>)requestedRedirectUri.getQueryParams());
        return schemeMatch && userInfoMatch && hostMatch && portMatch && pathMatch && queryParamMatch;
    }

    private boolean matchQueryParams(MultiValueMap<String, String> registeredRedirectUriQueryParams, MultiValueMap<String, String> requestedRedirectUriQueryParams) {
        for (String key : registeredRedirectUriQueryParams.keySet()) {
            List requestedRedirectUriQueryParamsValues;
            List registeredRedirectUriQueryParamsValues = (List)registeredRedirectUriQueryParams.get((Object)key);
            if (registeredRedirectUriQueryParamsValues.equals(requestedRedirectUriQueryParamsValues = (List)requestedRedirectUriQueryParams.get((Object)key))) continue;
            return false;
        }
        return true;
    }

    private boolean isEqual(String str1, String str2) {
        if (StringUtils.isEmpty((Object)str1) && StringUtils.isEmpty((Object)str2)) {
            return true;
        }
        if (!StringUtils.isEmpty((Object)str1)) {
            return str1.equals(str2);
        }
        return false;
    }

    protected boolean hostMatches(String registered, String requested) {
        if (this.matchSubdomains) {
            return this.isEqual(registered, requested) || requested != null && requested.endsWith("." + registered);
        }
        return this.isEqual(registered, requested);
    }

    private String obtainMatchingRedirect(Set<String> redirectUris, String requestedRedirect) {
        Assert.notEmpty(redirectUris, (String)"Redirect URIs cannot be empty");
        if (redirectUris.size() == 1 && requestedRedirect == null) {
            return redirectUris.iterator().next();
        }
        for (String redirectUri : redirectUris) {
            if (requestedRedirect == null || !this.redirectMatches(requestedRedirect, redirectUri)) continue;
            UriComponentsBuilder redirectUriBuilder = UriComponentsBuilder.fromUriString((String)redirectUri);
            UriComponents requestedRedirectUri = UriComponentsBuilder.fromUriString((String)requestedRedirect).build();
            if (this.matchSubdomains) {
                redirectUriBuilder.host(requestedRedirectUri.getHost());
            }
            if (!this.matchPorts) {
                redirectUriBuilder.port(requestedRedirectUri.getPort());
            }
            redirectUriBuilder.replaceQuery(requestedRedirectUri.getQuery());
            redirectUriBuilder.fragment(null);
            return redirectUriBuilder.build().toUriString();
        }
        throw new RedirectMismatchException("Invalid redirect: " + requestedRedirect + " does not match one of the registered values.");
    }
}

