/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.CommonPrefix;
import com.amazonaws.s3.model.EncodingType;
import com.amazonaws.s3.model.MultipartUpload;
import java.util.List;
import java.util.Objects;

public class ListMultipartUploadsOutput {
    String bucket;
    String keyMarker;
    String uploadIdMarker;
    String nextKeyMarker;
    String prefix;
    String delimiter;
    String nextUploadIdMarker;
    Integer maxUploads;
    Boolean isTruncated;
    List<MultipartUpload> uploads;
    List<CommonPrefix> commonPrefixes;
    EncodingType encodingType;

    ListMultipartUploadsOutput() {
        this.bucket = "";
        this.keyMarker = "";
        this.uploadIdMarker = "";
        this.nextKeyMarker = "";
        this.prefix = "";
        this.delimiter = "";
        this.nextUploadIdMarker = "";
        this.maxUploads = null;
        this.isTruncated = null;
        this.uploads = null;
        this.commonPrefixes = null;
        this.encodingType = null;
    }

    protected ListMultipartUploadsOutput(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyMarker = builder.keyMarker;
        this.uploadIdMarker = builder.uploadIdMarker;
        this.nextKeyMarker = builder.nextKeyMarker;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.nextUploadIdMarker = builder.nextUploadIdMarker;
        this.maxUploads = builder.maxUploads;
        this.isTruncated = builder.isTruncated;
        this.uploads = builder.uploads;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(ListMultipartUploadsOutput.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof ListMultipartUploadsOutput;
    }

    public String bucket() {
        return this.bucket;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public String nextKeyMarker() {
        return this.nextKeyMarker;
    }

    public String prefix() {
        return this.prefix;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String nextUploadIdMarker() {
        return this.nextUploadIdMarker;
    }

    public Integer maxUploads() {
        return this.maxUploads;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public List<MultipartUpload> uploads() {
        return this.uploads;
    }

    public List<CommonPrefix> commonPrefixes() {
        return this.commonPrefixes;
    }

    public EncodingType encodingType() {
        return this.encodingType;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String keyMarker;
        String uploadIdMarker;
        String nextKeyMarker;
        String prefix;
        String delimiter;
        String nextUploadIdMarker;
        Integer maxUploads;
        Boolean isTruncated;
        List<MultipartUpload> uploads;
        List<CommonPrefix> commonPrefixes;
        EncodingType encodingType;

        protected BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsOutput model) {
            this.bucket(model.bucket);
            this.keyMarker(model.keyMarker);
            this.uploadIdMarker(model.uploadIdMarker);
            this.nextKeyMarker(model.nextKeyMarker);
            this.prefix(model.prefix);
            this.delimiter(model.delimiter);
            this.nextUploadIdMarker(model.nextUploadIdMarker);
            this.maxUploads(model.maxUploads);
            this.isTruncated(model.isTruncated);
            this.uploads(model.uploads);
            this.commonPrefixes(model.commonPrefixes);
            this.encodingType(model.encodingType);
        }

        @Override
        public ListMultipartUploadsOutput build() {
            return new ListMultipartUploadsOutput(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        @Override
        public final Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        @Override
        public final Builder nextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
            return this;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        public final Builder nextUploadIdMarker(String nextUploadIdMarker) {
            this.nextUploadIdMarker = nextUploadIdMarker;
            return this;
        }

        @Override
        public final Builder maxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
            return this;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        @Override
        public final Builder uploads(List<MultipartUpload> uploads) {
            this.uploads = uploads;
            return this;
        }

        @Override
        public final Builder commonPrefixes(List<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String keyMarker() {
            return this.keyMarker;
        }

        public String uploadIdMarker() {
            return this.uploadIdMarker;
        }

        public String nextKeyMarker() {
            return this.nextKeyMarker;
        }

        public String prefix() {
            return this.prefix;
        }

        public String delimiter() {
            return this.delimiter;
        }

        public String nextUploadIdMarker() {
            return this.nextUploadIdMarker;
        }

        public Integer maxUploads() {
            return this.maxUploads;
        }

        public Boolean isTruncated() {
            return this.isTruncated;
        }

        public List<MultipartUpload> uploads() {
            return this.uploads;
        }

        public List<CommonPrefix> commonPrefixes() {
            return this.commonPrefixes;
        }

        public EncodingType encodingType() {
            return this.encodingType;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder keyMarker(String var1);

        public Builder uploadIdMarker(String var1);

        public Builder nextKeyMarker(String var1);

        public Builder prefix(String var1);

        public Builder delimiter(String var1);

        public Builder nextUploadIdMarker(String var1);

        public Builder maxUploads(Integer var1);

        public Builder isTruncated(Boolean var1);

        public Builder uploads(List<MultipartUpload> var1);

        public Builder commonPrefixes(List<CommonPrefix> var1);

        public Builder encodingType(EncodingType var1);

        public ListMultipartUploadsOutput build();
    }
}

