/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.ObjectLockConfiguration;
import com.amazonaws.s3.model.RequestPayer;
import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class PutObjectLockConfigurationRequest {
    String bucket;
    ObjectLockConfiguration objectLockConfiguration;
    RequestPayer requestPayer;
    String token;
    String contentMD5;
    String expectedBucketOwner;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    PutObjectLockConfigurationRequest() {
        this.bucket = "";
        this.objectLockConfiguration = null;
        this.requestPayer = null;
        this.token = "";
        this.contentMD5 = "";
        this.expectedBucketOwner = "";
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected PutObjectLockConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.objectLockConfiguration = builder.objectLockConfiguration;
        this.requestPayer = builder.requestPayer;
        this.token = builder.token;
        this.contentMD5 = builder.contentMD5;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutObjectLockConfigurationRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutObjectLockConfigurationRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public ObjectLockConfiguration objectLockConfiguration() {
        return this.objectLockConfiguration;
    }

    public RequestPayer requestPayer() {
        return this.requestPayer;
    }

    public String token() {
        return this.token;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        ObjectLockConfiguration objectLockConfiguration;
        RequestPayer requestPayer;
        String token;
        String contentMD5;
        String expectedBucketOwner;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutObjectLockConfigurationRequest model) {
            this.bucket(model.bucket);
            this.objectLockConfiguration(model.objectLockConfiguration);
            this.requestPayer(model.requestPayer);
            this.token(model.token);
            this.contentMD5(model.contentMD5);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public PutObjectLockConfigurationRequest build() {
            return new PutObjectLockConfigurationRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder objectLockConfiguration(ObjectLockConfiguration objectLockConfiguration) {
            this.objectLockConfiguration = objectLockConfiguration;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public ObjectLockConfiguration objectLockConfiguration() {
            return this.objectLockConfiguration;
        }

        public RequestPayer requestPayer() {
            return this.requestPayer;
        }

        public String token() {
            return this.token;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder objectLockConfiguration(ObjectLockConfiguration var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder token(String var1);

        public Builder contentMD5(String var1);

        public Builder expectedBucketOwner(String var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public PutObjectLockConfigurationRequest build();
    }
}

