/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageFlushCallback;
import software.amazon.awssdk.crt.eventstream.MessageType;

public class ClientConnectionContinuation
extends CrtResource {
    ClientConnectionContinuation(long ptr) {
        this.acquireNativeHandle(ptr);
    }

    public void activate(String operationName, List<Header> headers, byte[] payload, MessageType messsageType, int messageFlags, MessageFlushCallback callback) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        byte[] headersBuf = headers != null ? Header.marshallHeadersForJNI(headers) : null;
        int result = ClientConnectionContinuation.activateContinuation(this.getNativeHandle(), this, operationName.getBytes(StandardCharsets.UTF_8), headersBuf, payload, messsageType.getEnumValue(), messageFlags, callback);
        if (result != 0) {
            int errorCode = CRT.awsLastError();
            throw new CrtRuntimeException(errorCode);
        }
    }

    public CompletableFuture<Void> activate(String operationName, List<Header> headers, byte[] payload, MessageType messsageType, int messageFlags) {
        final CompletableFuture<Void> messageFlush = new CompletableFuture<Void>();
        this.activate(operationName, headers, payload, messsageType, messageFlags, new MessageFlushCallback(){

            @Override
            public void onCallbackInvoked(int errorCode) {
                if (errorCode == 0) {
                    messageFlush.complete(null);
                } else {
                    messageFlush.completeExceptionally(new CrtRuntimeException(errorCode));
                }
            }
        });
        return messageFlush;
    }

    public void sendMessage(List<Header> headers, byte[] payload, MessageType messsageType, int messageFlags, MessageFlushCallback callback) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        byte[] headersBuf = headers != null ? Header.marshallHeadersForJNI(headers) : null;
        int result = ClientConnectionContinuation.sendContinuationMessage(this.getNativeHandle(), headersBuf, payload, messsageType.getEnumValue(), messageFlags, callback);
        if (result != 0) {
            int errorCode = CRT.awsLastError();
            throw new CrtRuntimeException(errorCode);
        }
    }

    public CompletableFuture<Void> sendMessage(List<Header> headers, byte[] payload, MessageType messsageType, int messageFlags) {
        if (this.isNull()) {
            throw new IllegalStateException("close() has already been called on this object.");
        }
        final CompletableFuture<Void> messageFlush = new CompletableFuture<Void>();
        this.sendMessage(headers, payload, messsageType, messageFlags, new MessageFlushCallback(){

            @Override
            public void onCallbackInvoked(int errorCode) {
                if (errorCode == 0) {
                    messageFlush.complete(null);
                } else {
                    messageFlush.completeExceptionally(new CrtRuntimeException(errorCode));
                }
            }
        });
        return messageFlush;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            ClientConnectionContinuation.releaseContinuation(this.getNativeHandle());
        }
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    private static native int activateContinuation(long var0, ClientConnectionContinuation var2, byte[] var3, byte[] var4, byte[] var5, int var6, int var7, MessageFlushCallback var8);

    private static native int sendContinuationMessage(long var0, byte[] var2, byte[] var3, int var4, int var5, MessageFlushCallback var6);

    private static native void releaseContinuation(long var0);
}

