/*
 * Decompiled with CFR 0.152.
 */
package top.javatool.canal.client.spring.boot.autoconfigure;

import com.alibaba.otter.canal.protocol.CanalEntry;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import top.javatool.canal.client.client.ClusterCanalClient;
import top.javatool.canal.client.factory.EntryColumnModelFactory;
import top.javatool.canal.client.factory.IModelFactory;
import top.javatool.canal.client.handler.EntryHandler;
import top.javatool.canal.client.handler.MessageHandler;
import top.javatool.canal.client.handler.RowDataHandler;
import top.javatool.canal.client.handler.impl.AsyncMessageHandlerImpl;
import top.javatool.canal.client.handler.impl.RowDataHandlerImpl;
import top.javatool.canal.client.handler.impl.SyncMessageHandlerImpl;
import top.javatool.canal.client.spring.boot.autoconfigure.ThreadPoolAutoConfiguration;
import top.javatool.canal.client.spring.boot.properties.CanalSimpleProperties;

@Configuration
@EnableConfigurationProperties(value={CanalSimpleProperties.class})
@ConditionalOnBean(value={EntryHandler.class})
@ConditionalOnProperty(value={"canal.mode"}, havingValue="cluster")
@Import(value={ThreadPoolAutoConfiguration.class})
public class ClusterClientAutoConfiguration {
    private CanalSimpleProperties canalSimpleProperties;

    public ClusterClientAutoConfiguration(CanalSimpleProperties canalSimpleProperties) {
        this.canalSimpleProperties = canalSimpleProperties;
    }

    @Bean
    public RowDataHandler<CanalEntry.RowData> rowDataHandler() {
        return new RowDataHandlerImpl((IModelFactory)new EntryColumnModelFactory());
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="true", matchIfMissing=true)
    public MessageHandler messageHandler(RowDataHandler<CanalEntry.RowData> rowDataHandler, List<EntryHandler> entryHandlers, ExecutorService executorService) {
        return new AsyncMessageHandlerImpl(entryHandlers, rowDataHandler, executorService);
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="false")
    public MessageHandler messageHandler(RowDataHandler<CanalEntry.RowData> rowDataHandler, List<EntryHandler> entryHandlers) {
        return new SyncMessageHandlerImpl(entryHandlers, rowDataHandler);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public ClusterCanalClient clusterCanalClient(MessageHandler messageHandler) {
        return ClusterCanalClient.Builder.builder().canalServers(this.canalSimpleProperties.getServer()).destination(this.canalSimpleProperties.getDestination()).userName(this.canalSimpleProperties.getUserName()).messageHandler(messageHandler).password(this.canalSimpleProperties.getPassword()).batchSize(this.canalSimpleProperties.getBatchSize()).filter(this.canalSimpleProperties.getFilter()).timeout(this.canalSimpleProperties.getTimeout()).unit(this.canalSimpleProperties.getUnit()).build();
    }
}

