/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.model.formatter;

import java.lang.reflect.Field;
import java.util.List;
import us.codecraft.webmagic.model.annotation.Formatter;
import us.codecraft.webmagic.model.formatter.BasicTypeFormatter;
import us.codecraft.webmagic.model.formatter.ObjectFormatter;
import us.codecraft.webmagic.model.formatter.ObjectFormatters;

public class ObjectFormatterBuilder {
    private Field field;

    public ObjectFormatterBuilder setField(Field field) {
        this.field = field;
        return this;
    }

    private ObjectFormatter initFormatterForType(Class<?> fieldClazz, String[] params) {
        if (fieldClazz.equals(String.class) || List.class.isAssignableFrom(fieldClazz)) {
            return null;
        }
        Class<? extends ObjectFormatter> formatterClass = ObjectFormatters.get(BasicTypeFormatter.detectBasicClass(fieldClazz));
        if (formatterClass == null) {
            throw new IllegalStateException("Can't find formatter for field " + this.field.getName() + " of type " + fieldClazz);
        }
        return this.initFormatter(formatterClass, params);
    }

    private ObjectFormatter initFormatter(Class<? extends ObjectFormatter> formatterClazz, String[] params) {
        try {
            ObjectFormatter objectFormatter = formatterClazz.newInstance();
            objectFormatter.initParam(params);
            return objectFormatter;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectFormatter build() {
        Formatter formatter = this.field.getAnnotation(Formatter.class);
        if (formatter != null && !formatter.formatter().equals(Formatter.DEFAULT_FORMATTER)) {
            return this.initFormatter(formatter.formatter(), formatter.value());
        }
        if (formatter == null || formatter.subClazz().equals(Void.class)) {
            return this.initFormatterForType(this.field.getType(), formatter != null ? formatter.value() : null);
        }
        return this.initFormatterForType(formatter.subClazz(), formatter.value());
    }
}

