/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scheduler;

import com.alibaba.fastjson.JSON;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.RedisScheduler;

public class RedisPriorityScheduler
extends RedisScheduler {
    private static final String ZSET_PREFIX = "zset_";
    private static final String QUEUE_PREFIX = "queue_";
    private static final String NO_PRIORITY_SUFFIX = "_zore";
    private static final String PLUS_PRIORITY_SUFFIX = "_plus";
    private static final String MINUS_PRIORITY_SUFFIX = "_minus";

    public RedisPriorityScheduler(String host) {
        super(host);
    }

    public RedisPriorityScheduler(JedisPool pool) {
        super(pool);
    }

    @Override
    protected void pushWhenNoDuplicate(Request request, Task task) {
        try (Jedis jedis = this.pool.getResource();){
            if (request.getPriority() > 0L) {
                jedis.zadd(this.getZsetPlusPriorityKey(task), (double)request.getPriority(), request.getUrl());
            } else if (request.getPriority() < 0L) {
                jedis.zadd(this.getZsetMinusPriorityKey(task), (double)request.getPriority(), request.getUrl());
            } else {
                jedis.lpush(this.getQueueNoPriorityKey(task), new String[]{request.getUrl()});
            }
            this.setExtrasInItem(jedis, request, task);
        }
    }

    @Override
    public synchronized Request poll(Task task) {
        try (Jedis jedis = this.pool.getResource();){
            String url = this.getRequest(jedis, task);
            if (StringUtils.isBlank((CharSequence)url)) {
                Request request = null;
                return request;
            }
            Request request = this.getExtrasInItem(jedis, url, task);
            return request;
        }
    }

    private String getRequest(Jedis jedis, Task task) {
        String url;
        Set urls = jedis.zrevrange(this.getZsetPlusPriorityKey(task), 0L, 0L);
        if (urls.isEmpty()) {
            url = jedis.lpop(this.getQueueNoPriorityKey(task));
            if (StringUtils.isBlank((CharSequence)url) && !(urls = jedis.zrevrange(this.getZsetMinusPriorityKey(task), 0L, 0L)).isEmpty()) {
                url = urls.toArray(new String[0])[0];
                jedis.zrem(this.getZsetMinusPriorityKey(task), new String[]{url});
            }
        } else {
            url = urls.toArray(new String[0])[0];
            jedis.zrem(this.getZsetPlusPriorityKey(task), new String[]{url});
        }
        return url;
    }

    @Override
    public void resetDuplicateCheck(Task task) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(this.getSetKey(task));
        }
    }

    private String getZsetPlusPriorityKey(Task task) {
        return ZSET_PREFIX + task.getUUID() + PLUS_PRIORITY_SUFFIX;
    }

    private String getQueueNoPriorityKey(Task task) {
        return QUEUE_PREFIX + task.getUUID() + NO_PRIORITY_SUFFIX;
    }

    private String getZsetMinusPriorityKey(Task task) {
        return ZSET_PREFIX + task.getUUID() + MINUS_PRIORITY_SUFFIX;
    }

    private void setExtrasInItem(Jedis jedis, Request request, Task task) {
        if (!request.getExtras().isEmpty()) {
            String field = DigestUtils.sha1Hex((String)request.getUrl());
            String value = JSON.toJSONString((Object)request);
            jedis.hset(this.getItemKey(task), field, value);
        }
    }

    private Request getExtrasInItem(Jedis jedis, String url, Task task) {
        String key = this.getItemKey(task);
        String field = DigestUtils.sha1Hex((String)url);
        byte[] bytes = jedis.hget(key.getBytes(), field.getBytes());
        if (bytes != null) {
            return (Request)JSON.parseObject((String)new String(bytes), Request.class);
        }
        return new Request(url);
    }
}

