/*
 * $Id: ElementValidator.java,v 1.2 1999/04/11 17:25:02 db Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


package com.sun.xml.parser;

import org.xml.sax.SAXException;

/**
 * Base class used within the parser to validate element content.
 * Different content models involve different validation rules,
 * and some involve state about the elements seen thus far.  This
 * base class corresponds to the "ANY" content model, and accepts
 * all content.
 *
 * @author David Brownell
 * @version $Revision: 1.2 $
 */
class ElementValidator
{
    // package private
    static final ElementValidator ANY = new ElementValidator ();

    /** Consumes an element of the given type */
    public void consume (String type) throws SAXException
	{}

    /** Consumes parsed or unparsed text data */
    public void text () throws SAXException
	{}

    /** Called when the element content is done */
    public void done () throws SAXException
	{}
}
