/*
 * $Id: CDataNode.java,v 1.3 1999/04/20 00:11:10 mode Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.sun.xml.tree;


import java.io.Writer;
import java.io.IOException;

import org.w3c.dom.*;


/**
 * Node representing XML CDATA text, which is just like other text except
 * for its delimiters (<em>&lt;[CDATA[</em>text<em>]]&gt;</em>).  CDATA
 * is used to embed markup, program source code, and other kinds of text
 * that use XML markup delimiters (<em>&lt;</em> and <em>&amp;</em>) for
 * their own nefarious purposes.
 *
 * @author David Brownell
 * @version $Revision: 1.3 $
 */
//public
class CDataNode extends TextNode implements CDATASection
{
    /**
     * Constructs a CDATA text object with no text.
     */
    public CDataNode () { }

        
    /**
     * Constructs CDATA text object by copying text from the input buffer.
     */
    public CDataNode (char buf [], int offset, int len)
    {
	super (buf, offset, len);
    }

    /**
     * Constructs a CDATA text object by copying text from the string.
     */
    public CDataNode (String s)
    {
	super (s);
    }

    /**
     * Writes the text, breaking this into multiple CDATA sections
     * if necessary to escape <em>[[&lt;</em> in the data.
     */
    public void writeXml (XmlWriteContext context) throws IOException
    {
	Writer	out = context.getWriter ();
	out.write ("<![CDATA[");
	for (int i = 0; i < data.length; i++) {
	    char c = data [i];

	    // embedded "]]>" needs to be split into adjacent
	    // CDATA blocks ... can be split at either point
	    if (c == ']') {
		if ((i + 2) < data.length
			&& data [i + 1] == ']'
			&& data [i + 2] == '>') {
		    out.write ("]]]]><![CDATA[>");
		    continue;
		}
	    }
	    out.write (c);
	}
	out.write ("]]>");
    }

    // DOM support

    /** DOM: Returns the CDATA_SECTION_NODE node type constant. */
    public short getNodeType () { return CDATA_SECTION_NODE; }

    /** Returns a new CDATA section with the same content as this. */
    public Node cloneNode (boolean deep)
    {
    	CDataNode retval = new CDataNode (data, 0, data.length);
	retval.setOwnerDocument ((XmlDocument)this.getOwnerDocument ());
	return retval;
    }

    /** Returns the string "#cdata-section".*/
    public String getNodeName () { return "#cdata-section"; }
}
