// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>By far the vast majority of objects (apart from text)
      that authors encounter when traversing a document
      are <A HREF='Element.html'><CODE>Element</CODE></A> nodes.  
      Assume the following XML document:
<CODE><PRE>
&lt;elementExample id="demo"&gt;
  &lt;subelement1/&gt;
  &lt;subelement2&gt;&lt;subsubelement/&gt;&lt;/subelement2&gt;
&lt;/elementExample&gt;  
</PRE></CODE>

<P>When represented using DOM, the top node is an <A HREF='Element.html'><CODE>Element</CODE></A> node
      for "elementExample", which contains two child <A HREF='Element.html'><CODE>Element</CODE></A>
      nodes, one for "subelement1" and one
      for "subelement2". "subelement1" contains no
      child nodes.
<P>Elements may have attributes associated with them; since the
    <A HREF='Element.html'><CODE>Element</CODE></A> interface inherits from <A HREF='Node.html'><CODE>Node</CODE></A>, the generic
    <A HREF='Node.html'><CODE>Node</CODE></A> interface method <code>getAttributes</code> may be used
    to retrieve the set of all attributes for an element.  There are methods on
    the <A HREF='Element.html'><CODE>Element</CODE></A> interface to retrieve either an <A HREF='Attr.html'><CODE>Attr</CODE></A>
    object by name or an attribute value by name. In XML, where an attribute
    value may contain entity references, an <A HREF='Attr.html'><CODE>Attr</CODE></A> object should be
    retrieved to examine the possibly fairly complex sub-tree representing the
    attribute value. On the other hand, in HTML, where all attributes have
    simple string values, methods to directly access an attribute value can
    safely be used as a convenience.

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tagName><CODE>&nbsp;tagName</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTagName()'>getTagName</a>
</TD>
<TD><P>The name of the element. For example, in:  
<CODE><PRE>
&lt;elementExample id="demo"&gt; 
        ... 
&lt;/elementExample&gt; ,
</PRE></CODE>
<code>tagName</code> has the value
     <code>"elementExample"</code>. Note that this is
     case-preserving in XML, as are all of the operations of the DOM.
     The HTML DOM returns the <code>tagName</code> of an HTML element
     in the canonical uppercase form, regardless of the case in the 
     source HTML document. 
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface Element
extends Node
{
	/**
	 * Returns the value of the <code><a href=#att-tagName>tagName</a></code> property.
	*/
	String getTagName ();


/**
<P>Retrieves an attribute value by name.

@return The <A HREF='Attr.html'><CODE>Attr</CODE></A> value as a string, or the empty 
	string if that attribute does not have a specified or default value.
@param name
The name of the attribute to retrieve.
*/
String getAttribute (String name);

/**
<P>Adds a new attribute. If an attribute with that name is already
      present in the element, its value is changed to be that of the value
      parameter. This value is a simple string, it is not parsed as it is being
      set. So any markup (such as syntax to be recognized as an entity
      reference) is treated as literal text, and needs to be appropriately
      escaped by the implementation when it is written out. In order to assign
      an attribute value that contains entity references, the user must create
      an <A HREF='Attr.html'><CODE>Attr</CODE></A> node plus any <A HREF='Text.html'><CODE>Text</CODE></A> and
      <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> nodes, build the appropriate subtree, and
      use <code>setAttributeNode</code> to assign it as the value of an
      attribute.

@param name
The name of the attribute to create or alter.
@param value
Value to set in string form.
@exception INVALID_CHARACTER_ERR: Raised if the specified name contains
	an invalid character.<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

*/
void setAttribute (String name, String value) throws DOMException;

/**
<P>Removes an attribute by name. If the removed attribute
	has a default value it is immediately replaced.

@param name
The name of the attribute to remove.
@exception NO_MODIFICATION_ALLOWED_ERR: Raised if this node is
	readonly.
*/
void removeAttribute (String name) throws DOMException;

/**
<P>Retrieves an <A HREF='Attr.html'><CODE>Attr</CODE></A> node by name.

@return The <A HREF='Attr.html'><CODE>Attr</CODE></A> node with the specified attribute
	  name or <code>null</code> if there is no such attribute.
@param name
The name of the attribute to retrieve.
*/
Attr getAttributeNode (String name);

/**
<P>Adds a new attribute. If an attribute with that
	name is already present in the element, it is replaced
	by the new one.

@return If the <code>newAttr</code> attribute replaces
	an existing attribute with the same name, the 
	previously existing <A HREF='Attr.html'><CODE>Attr</CODE></A> node is returned, otherwise
	<code>null</code> is returned.
@param newAttr
The <A HREF='Attr.html'><CODE>Attr</CODE></A> node to add to the attribute
	    list.
@exception WRONG_DOCUMENT_ERR: Raised if <code>newAttr</code> was
	created from a different document than the one that created the
	element.<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
<P>INUSE_ATTRIBUTE_ERR: Raised if <code>newAttr</code> is already
	an attribute of another <A HREF='Element.html'><CODE>Element</CODE></A> object. The
	DOM user must explicitly clone <A HREF='Attr.html'><CODE>Attr</CODE></A>
	nodes to re-use them in other elements.

*/
Attr setAttributeNode (Attr newAttr) throws DOMException;

/**
<P>Removes the specified attribute.

@return The <A HREF='Attr.html'><CODE>Attr</CODE></A> node that was removed.
@param oldAttr
The <A HREF='Attr.html'><CODE>Attr</CODE></A> node to remove from the attribute
	list. If the removed <A HREF='Attr.html'><CODE>Attr</CODE></A> has a default value it is
	immediately replaced.
@exception NO_MODIFICATION_ALLOWED_ERR: Raised if this node is
	readonly.<P>NOT_FOUND_ERR: Raised if <code>oldAttr</code> is not an attribute of
	the element.

*/
Attr removeAttributeNode (Attr oldAttr) throws DOMException;

/**
<P>Returns a <A HREF='NodeList.html'><CODE>NodeList</CODE></A> of all descendant elements with a
	given tag name, in the order in which they would be encountered in a
	preorder traversal of the <A HREF='Element.html'><CODE>Element</CODE></A> tree.

@return A list of matching <A HREF='Element.html'><CODE>Element</CODE></A> nodes.
@param name
The name of the tag to match on. The special value "*"
	    matches all tags.
*/
NodeList getElementsByTagName (String name);

/**
<P>Puts all <A HREF='Text.html'><CODE>Text</CODE></A> nodes in the full depth of the
        sub-tree underneath this <A HREF='Element.html'><CODE>Element</CODE></A> into a "normal" form
	where only markup (e.g., tags, comments, processing instructions, CDATA
	sections, and entity references) separates <A HREF='Text.html'><CODE>Text</CODE></A> nodes,
	i.e., there are no adjacent <A HREF='Text.html'><CODE>Text</CODE></A> nodes.  This can be used
	to ensure that the DOM view of a document is the same as if it were
	saved and re-loaded, and is useful when operations (such as XPointer
	lookups) that depend on a particular document tree structure are to be
	used.

*/
void normalize ();

}
