// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>The 
  <code>Node</code> interface is the primary datatype for the entire Document Object Model. It represents a single node in the document tree. While all objects implementing the 
  <code>Node</code> interface expose methods for dealing with children, not all objects implementing the 
  <code>Node</code>
 interface may have children. For example, 
  <code>Text</code>
 nodes may not have children, and adding children to such nodes results in a 
  <code>DOMException</code> being raised. 

<P>The attributes 
  <code>nodeName</code>, 
  <code>nodeValue</code>  and 
  <code>attributes</code> are included as a mechanism to get at node information without casting down to the specific derived interface. In cases where there is no obvious mapping of these attributes for a specific 
  <code>nodeType</code> (e.g., 
  <code>nodeValue</code> for an Element or 
  <code>attributes</code>  for a Comment), this returns 
  <code>null</code>. Note that the specialized interfaces may contain additional and more convenient mechanisms to get and set the relevant information.


<P>The values of 
  <code>nodeName</code>, 
  <code>nodeValue</code>, and 
  <code>attributes</code> vary according to the node type as follows: 
  <center><table border="1">
    <tbody>
      <tr>
	<td BGCOLOR="#ccccff">Node Type</td>
	<td BGCOLOR="#ccccff">nodeName</td>
	<td BGCOLOR="#ccccff">nodeValue</td>
	<td BGCOLOR="#ccccff">attributes</td>
      </tr>
      <tr>
	<td>Element</td>
	<td>tagName</td>
	<td>null</td>
	<td>NamedNodeMap</td>
      </tr>
      <tr>
	<td>Attr</td>
	<td>name of attribute</td>
	<td>value of attribute</td>
	<td>null</td>
      </tr>
      <tr>
	<td>Text</td>
	<td>#text</td>
	<td>content of the text node</td>
	<td>null</td>
      </tr>
      <tr>
	<td>CDATASection</td>
	<td>#cdata-section</td>
	<td>content of the CDATA Section</td>
	<td>null</td>
      </tr>
      <tr>
	<td>EntityReference</td>
	<td>name of entity referenced</td>
	<td>null</td>
	<td>null</td>
      </tr>
      <tr>
	<td>Entity</td>
	<td>entity name</td>
	<td>null</td>
	<td>null</td>
      </tr>
      <tr>
	<td>ProcessingInstruction</td>
	<td>target</td>
	<td>entire content excluding the target</td>
	<td>null</td>
      </tr>
      <tr>
	<td>Comment</td>
	<td>#comment</td>
	<td>content of the comment</td>
	<td>null</td>
      </tr>
      <tr>
	<td>Document</td>
	<td>#document</td>
	<td>null</td>
	<td>null</td>
      </tr>
      <tr>
	<td>DocumentType</td>
	<td>document type name</td>
	<td>null</td>
	<td>null</td>
      </tr>
      <tr>
	<td>DocumentFragment</td>
	<td>#document-fragment</td>
	<td>null</td>
	<td>null</td>
      </tr>
      <tr>
	<td>Notation</td>
	<td>notation name</td>
	<td>null</td>
	<td>null</td>
      </tr>
    </tbody>
  </table></center>

 

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-nodeName><CODE>&nbsp;nodeName</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNodeName()'>getNodeName</a>
</TD>
<TD><P>The name of this node, depending on its type; see the table above. 
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-nodeValue><CODE>&nbsp;nodeValue</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNodeValue()'>getNodeValue</a>
<a href='#setNodeValue(java.lang.String)'>setNodeValue</a>
</TD>
<TD><P>The value of this node, depending on its type; see the table above.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-nodeType><CODE>&nbsp;nodeType</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNodeType()'>getNodeType</a>
</TD>
<TD><P>A code representing the type of the underlying object, as defined above.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-parentNode><CODE>&nbsp;parentNode</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getParentNode()'>getParentNode</a>
</TD>
<TD><P>The parent of this node. All nodes, except 
  <code>Document</code>, 
  <code>DocumentFragment</code>, and 
  <code>Attr</code> may have a parent. However, if a node has just been created and not yet added to the tree, or if it has been removed from the tree, this is 
  <code>null</code>.

</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-childNodes><CODE>&nbsp;childNodes</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getChildNodes()'>getChildNodes</a>
</TD>
<TD><P>A 
  <code>NodeList</code> that contains all children of this node. If there are no children, this is a 
  <code>NodeList</code> containing no nodes. The content of the returned 
  <code>NodeList</code> is "live" in the sense that, for instance, changes to the children of the node object that it was created from are immediately reflected in the nodes returned by the 
  <code>NodeList</code> accessors; it is not a static snapshot of the content of the node. This is true for every 
  <code>NodeList</code>, including the ones returned by the 
  <code>getElementsByTagName</code> method.

</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-firstChild><CODE>&nbsp;firstChild</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getFirstChild()'>getFirstChild</a>
</TD>
<TD><P>The first child of this node. If there is no such node, this returns 
  <code>null</code>.

</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-lastChild><CODE>&nbsp;lastChild</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLastChild()'>getLastChild</a>
</TD>
<TD><P>The last child of this node. If there is no such node, this returns 
  <code>null</code>.

</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-previousSibling><CODE>&nbsp;previousSibling</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getPreviousSibling()'>getPreviousSibling</a>
</TD>
<TD><P>The node immediately preceding this node. If there is no such node, this returns 
  <code>null</code>.

</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-nextSibling><CODE>&nbsp;nextSibling</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNextSibling()'>getNextSibling</a>
</TD>
<TD><P>The node immediately following this node. If there is no such node, this returns 
  <code>null</code>.

</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-attributes><CODE>&nbsp;attributes</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAttributes()'>getAttributes</a>
</TD>
<TD><P>A 
  <code>NamedNodeMap</code> containing the attributes of this node (if it is an 
  <code>Element</code>) or 
  <code>null</code> otherwise. 

</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-ownerDocument><CODE>&nbsp;ownerDocument</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getOwnerDocument()'>getOwnerDocument</a>
</TD>
<TD><P>The 
  <code>Document</code> object associated with this node. This is also the 
  <code>Document</code> object used to create new nodes. When this node is a 
  <code>Document</code> this is 
  <code>null</code>.

</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface Node
{
/**
The node is a <A HREF='Element.html'><CODE>Element</CODE></A>.
*/
public static final short ELEMENT_NODE = 1;

/**
The node is an <A HREF='Attr.html'><CODE>Attr</CODE></A>.
*/
public static final short ATTRIBUTE_NODE = 2;

/**
The node is a <A HREF='Text.html'><CODE>Text</CODE></A> node.
*/
public static final short TEXT_NODE = 3;

/**
The node is a <A HREF='CDATASection.html'><CODE>CDATASection</CODE></A>.
*/
public static final short CDATA_SECTION_NODE = 4;

/**
The node is an <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A>.
*/
public static final short ENTITY_REFERENCE_NODE = 5;

/**
The node is an <A HREF='Entity.html'><CODE>Entity</CODE></A>.
*/
public static final short ENTITY_NODE = 6;

/**
The node is a <A HREF='ProcessingInstruction.html'><CODE>ProcessingInstruction</CODE></A>.
*/
public static final short PROCESSING_INSTRUCTION_NODE = 7;

/**
The node is a <A HREF='Comment.html'><CODE>Comment</CODE></A>.
*/
public static final short COMMENT_NODE = 8;

/**
The node is a <A HREF='Document.html'><CODE>Document</CODE></A>.
*/
public static final short DOCUMENT_NODE = 9;

/**
The node is a <A HREF='DocumentType.html'><CODE>DocumentType</CODE></A>.
*/
public static final short DOCUMENT_TYPE_NODE = 10;

/**
The node is a <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A>.
*/
public static final short DOCUMENT_FRAGMENT_NODE = 11;

/**
The node is a <A HREF='Notation.html'><CODE>Notation</CODE></A>.
*/
public static final short NOTATION_NODE = 12;

	/**
	 * Returns the value of the <code><a href=#att-nodeName>nodeName</a></code> property.
	*/
	String getNodeName ();


	/** Assigns the value of the <code><a href=#att-nodeValue>nodeValue</a></code> property.
	 * @exception DOMException <P>NO_MODIFICATION_ALLOWED_ERR: Raised when the node is readonly.

 */
	void setNodeValue (String nodeValue) throws DOMException;

	/**
	 * Returns the value of the <code><a href=#att-nodeValue>nodeValue</a></code> property.
	* @exception DOMException <P>DOMSTRING_SIZE_ERR: Raised when it would return more characters than fit in a 
  <code>DOMString</code> variable on the implementation platform.


 */
	String getNodeValue () throws DOMException;


	/**
	 * Returns the value of the <code><a href=#att-nodeType>nodeType</a></code> property.
	*/
	short getNodeType ();


	/**
	 * Returns the value of the <code><a href=#att-parentNode>parentNode</a></code> property.
	*/
	Node getParentNode ();


	/**
	 * Returns the value of the <code><a href=#att-childNodes>childNodes</a></code> property.
	*/
	NodeList getChildNodes ();


	/**
	 * Returns the value of the <code><a href=#att-firstChild>firstChild</a></code> property.
	*/
	Node getFirstChild ();


	/**
	 * Returns the value of the <code><a href=#att-lastChild>lastChild</a></code> property.
	*/
	Node getLastChild ();


	/**
	 * Returns the value of the <code><a href=#att-previousSibling>previousSibling</a></code> property.
	*/
	Node getPreviousSibling ();


	/**
	 * Returns the value of the <code><a href=#att-nextSibling>nextSibling</a></code> property.
	*/
	Node getNextSibling ();


	/**
	 * Returns the value of the <code><a href=#att-attributes>attributes</a></code> property.
	*/
	NamedNodeMap getAttributes ();


	/**
	 * Returns the value of the <code><a href=#att-ownerDocument>ownerDocument</a></code> property.
	*/
	Document getOwnerDocument ();


/**
<P>Inserts the node 
  <code>newChild</code> before the existing child node 
  <code>refChild</code>. If 
  <code>refChild</code> is 
  <code>null</code>, insert 
  <code>newChild</code> at the end of the list of children.

<P>If 
  <code>newChild</code> is a 
  <code>DocumentFragment</code>
 object, all of its children are inserted, in the same order, before 
  <code>refChild</code>. If the 
  <code>newChild</code> is already in the tree, it is first removed.


@return The node being inserted.
@param newChild
The node to insert.
@param refChild
The reference node, i.e., the node before which the new node must be inserted.
@exception HIERARCHY_REQUEST_ERR: Raised if this node is of a type that does not allow children of the type of the <code>newChild</code>
 node, or if the node to insert is one of this node's ancestors.<P>WRONG_DOCUMENT_ERR: Raised if 
  <code>newChild</code> was created from a different document than the one that created this node.

<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
<P>NOT_FOUND_ERR: Raised if 
  <code>refChild</code> is not a child of this node.


*/
Node insertBefore (Node newChild, Node refChild) throws DOMException;

/**
<P>Replaces the child node 
  <code>oldChild</code> with 
  <code>newChild</code> in the list of children, and returns the 
  <code>oldChild</code> node. If the 
  <code>newChild</code> is already in the tree, it is first removed.


@return The node replaced.
@param newChild
The new node to put in the child list.
@param oldChild
The node being replaced in the list.
@exception HIERARCHY_REQUEST_ERR: Raised if this node is of a type that does not allow children of the type of the <code>newChild</code>
 node, or it the node to put in is one of this node's ancestors.<P>WRONG_DOCUMENT_ERR: Raised if 
  <code>newChild</code> was created from a different document than the one that created this node.

<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.
<P>NOT_FOUND_ERR: Raised if 
  <code>oldChild</code> is not a child of this node.


*/
Node replaceChild (Node newChild, Node oldChild) throws DOMException;

/**
<P>Removes the child node indicated by 
  <code>oldChild</code> from the list of children, and returns it.


@return The node removed.
@param oldChild
The node being removed.
@exception NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.<P>NOT_FOUND_ERR: Raised if 
  <code>oldChild</code> is not a child of this node.


*/
Node removeChild (Node oldChild) throws DOMException;

/**
<P>Adds the node 
  <code>newChild</code> to the end of the list of children of this node. If the 
  <code>newChild</code> is already in the tree, it is first removed.


@return The node added.
@param newChild
The node to add.<P>If it is a 
  <code>DocumentFragment</code>
 object, the entire contents of the document fragment are moved into the child list of this node


@exception HIERARCHY_REQUEST_ERR: Raised if this node is of a type that does not allow children of the type of the <code>newChild</code>
 node, or if the node to append is one of this node's ancestors.<P>WRONG_DOCUMENT_ERR: Raised if 
  <code>newChild</code> was created from a different document than the one that created this node.

<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

*/
Node appendChild (Node newChild) throws DOMException;

/**
<P> This is a convenience method to allow easy determination of whether a node has any children.

@return  <code>true</code> if the node has any children, <code>false</code> if the node has no children.
*/
boolean hasChildNodes ();

/**
<P>Returns a duplicate of this node, i.e., serves as a generic copy constructor for nodes. The duplicate node has no parent (
  <code>parentNode</code> returns 
  <code>null</code>.).

<P>Cloning an 
  <code>Element</code> copies all attributes and their values, including those generated by the XML processor to represent defaulted attributes, but this method does not copy any text it contains unless it is a deep clone, since the text is contained in a child 
  <code>Text</code> node. Cloning any other type of node simply returns a copy of this node. 


@return The duplicate node.
@param deep
If <code>true</code>, recursively clone the subtree under the specified node; if <code>false</code>, clone only the node itself (and its attributes, if it is an <A HREF='Element.html'><CODE>Element</CODE></A>). 
*/
Node cloneNode (boolean deep);

}
