// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Form control. 
    <emph>Note.</emph> Depending upon the environment the page is being viewed, the value property may be read-only for the file upload input type. For the "password" input type, the actual value returned may be masked to prevent unauthorized use. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-INPUT">INPUT element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-defaultValue><CODE>&nbsp;defaultValue</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDefaultValue()'>getDefaultValue</a>
<a href='#setDefaultValue(java.lang.String)'>setDefaultValue</a>
</TD>
<TD>
  <P>Stores the initial control value (i.e., the initial value of 
    <code>value</code>). 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-defaultChecked><CODE>&nbsp;defaultChecked</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDefaultChecked()'>getDefaultChecked</a>
<a href='#setDefaultChecked(java.lang.String)'>setDefaultChecked</a>
</TD>
<TD>
  <P>When 
    <code>type</code> has the value "Radio" or "Checkbox", stores the initial value of the 
    <code>checked</code> attribute. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-form><CODE>&nbsp;form</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getForm()'>getForm</a>
</TD>
<TD>
  <P>Returns the 
    <code>FORM</code> element containing this control. Returns null if this control is not within the context of a form. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-accept><CODE>&nbsp;accept</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAccept()'>getAccept</a>
<a href='#setAccept(java.lang.String)'>setAccept</a>
</TD>
<TD>
  <P>A comma-separated list of content types that a server processing this form will handle correctly. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accept">accept attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-accessKey><CODE>&nbsp;accessKey</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAccessKey()'>getAccessKey</a>
<a href='#setAccessKey(java.lang.String)'>setAccessKey</a>
</TD>
<TD>
  <P>A single character access key to give access to the form control. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accesskey">accesskey attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Aligns this object (vertically or horizontally) with respect to its surrounding text. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-align-IMG">align attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-alt><CODE>&nbsp;alt</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlt()'>getAlt</a>
<a href='#setAlt(java.lang.String)'>setAlt</a>
</TD>
<TD>
  <P>Alternate text for user agents not rendering the normal content of this element. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-alt">alt attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-checked><CODE>&nbsp;checked</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getChecked()'>getChecked</a>
<a href='#setChecked(java.lang.String)'>setChecked</a>
</TD>
<TD>
  <P>Describes whether a radio or check box is checked, when 
    <code>type</code> has the value "Radio" or "Checkbox". The value is TRUE if explicitly set. Represents the current state of the checkbox or radio button. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-checked">checked attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-disabled><CODE>&nbsp;disabled</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDisabled()'>getDisabled</a>
<a href='#setDisabled(java.lang.String)'>setDisabled</a>
</TD>
<TD>
  <P>The control is unavailable in this context. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">disabled attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-maxLength><CODE>&nbsp;maxLength</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getMaxLength()'>getMaxLength</a>
<a href='#setMaxLength(java.lang.String)'>setMaxLength</a>
</TD>
<TD>
  <P>Maximum number of characters for text fields, when 
    <code>type</code>
has the value "Text" or "Password". See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-maxlength">maxlength attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>Form control or object name when submitted with a form. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-INPUT">name attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-readOnly><CODE>&nbsp;readOnly</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getReadOnly()'>getReadOnly</a>
<a href='#setReadOnly(java.lang.String)'>setReadOnly</a>
</TD>
<TD>
  <P>This control is read-only. When 
    <code>type</code> has the value "text" or "password" only. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-readonly">readonly attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-size><CODE>&nbsp;size</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSize()'>getSize</a>
<a href='#setSize(java.lang.String)'>setSize</a>
</TD>
<TD>
  <P>Size information. The precise meaning is specific to each type of field. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-size-INPUT">size attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-src><CODE>&nbsp;src</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSrc()'>getSrc</a>
<a href='#setSrc(java.lang.String)'>setSrc</a>
</TD>
<TD>
  <P>When the 
    <code>type</code> attribute has the value "Image", this attribute specifies the location of the image to be used to decorate the graphical submit button. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-src">src attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tabIndex><CODE>&nbsp;tabIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTabIndex()'>getTabIndex</a>
<a href='#setTabIndex(java.lang.String)'>setTabIndex</a>
</TD>
<TD>
  <P>Index that represents the element's position in the tabbing order. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">tabindex attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-type><CODE>&nbsp;type</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getType()'>getType</a>
</TD>
<TD>
  <P>The type of control created. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-type-INPUT">type attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-useMap><CODE>&nbsp;useMap</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getUseMap()'>getUseMap</a>
<a href='#setUseMap(java.lang.String)'>setUseMap</a>
</TD>
<TD>
  <P>Use client-side image map. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-usemap">usemap attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-value><CODE>&nbsp;value</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getValue()'>getValue</a>
<a href='#setValue(java.lang.String)'>setValue</a>
</TD>
<TD>
  <P>The current form control value. Used for radio buttons and check boxes. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-value-INPUT">value attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLInputElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-defaultValue>defaultValue</a></code> property.
	 */
	void setDefaultValue (String defaultValue);

	/**
	 * Returns the value of the <code><a href=#att-defaultValue>defaultValue</a></code> property.
	*/
	String getDefaultValue ();


	/** Assigns the value of the <code><a href=#att-defaultChecked>defaultChecked</a></code> property.
	 */
	void setDefaultChecked (boolean defaultChecked);

	/**
	 * Returns the value of the <code><a href=#att-defaultChecked>defaultChecked</a></code> property.
	*/
	boolean getDefaultChecked ();


	/**
	 * Returns the value of the <code><a href=#att-form>form</a></code> property.
	*/
	HTMLFormElement getForm ();


	/** Assigns the value of the <code><a href=#att-accept>accept</a></code> property.
	 */
	void setAccept (String accept);

	/**
	 * Returns the value of the <code><a href=#att-accept>accept</a></code> property.
	*/
	String getAccept ();


	/** Assigns the value of the <code><a href=#att-accessKey>accessKey</a></code> property.
	 */
	void setAccessKey (String accessKey);

	/**
	 * Returns the value of the <code><a href=#att-accessKey>accessKey</a></code> property.
	*/
	String getAccessKey ();


	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-alt>alt</a></code> property.
	 */
	void setAlt (String alt);

	/**
	 * Returns the value of the <code><a href=#att-alt>alt</a></code> property.
	*/
	String getAlt ();


	/** Assigns the value of the <code><a href=#att-checked>checked</a></code> property.
	 */
	void setChecked (boolean checked);

	/**
	 * Returns the value of the <code><a href=#att-checked>checked</a></code> property.
	*/
	boolean getChecked ();


	/** Assigns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	 */
	void setDisabled (boolean disabled);

	/**
	 * Returns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	*/
	boolean getDisabled ();


	/** Assigns the value of the <code><a href=#att-maxLength>maxLength</a></code> property.
	 */
	void setMaxLength (int maxLength);

	/**
	 * Returns the value of the <code><a href=#att-maxLength>maxLength</a></code> property.
	*/
	int getMaxLength ();


	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-readOnly>readOnly</a></code> property.
	 */
	void setReadOnly (boolean readOnly);

	/**
	 * Returns the value of the <code><a href=#att-readOnly>readOnly</a></code> property.
	*/
	boolean getReadOnly ();


	/** Assigns the value of the <code><a href=#att-size>size</a></code> property.
	 */
	void setSize (String size);

	/**
	 * Returns the value of the <code><a href=#att-size>size</a></code> property.
	*/
	String getSize ();


	/** Assigns the value of the <code><a href=#att-src>src</a></code> property.
	 */
	void setSrc (String src);

	/**
	 * Returns the value of the <code><a href=#att-src>src</a></code> property.
	*/
	String getSrc ();


	/** Assigns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	 */
	void setTabIndex (int tabIndex);

	/**
	 * Returns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	*/
	int getTabIndex ();


	/**
	 * Returns the value of the <code><a href=#att-type>type</a></code> property.
	*/
	String getType ();


	/** Assigns the value of the <code><a href=#att-useMap>useMap</a></code> property.
	 */
	void setUseMap (String useMap);

	/**
	 * Returns the value of the <code><a href=#att-useMap>useMap</a></code> property.
	*/
	String getUseMap ();


	/** Assigns the value of the <code><a href=#att-value>value</a></code> property.
	 */
	void setValue (String value);

	/**
	 * Returns the value of the <code><a href=#att-value>value</a></code> property.
	*/
	String getValue ();


/**

  <P>Removes keyboard focus from this element.
</P>

*/
void blur ();

/**

  <P>Gives keyboard focus to this element.
</P>

*/
void focus ();

/**

  <P>Select the contents of the text area. For 
    <code>INPUT</code> elements whose 
    <code>type</code> attribute has one of the following values: "Text", "File", or "Password".
  
</P>

*/
void select ();

/**

  <P>Simulate a mouse-click. For 
    <code>INPUT</code> elements whose 
    <code>type</code> attribute has one of the following values: "Button", "Checkbox", "Radio", "Reset", or "Submit".
  
</P>

*/
void click ();

}
