// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Form field label text. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-LABEL">LABEL element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-form><CODE>&nbsp;form</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getForm()'>getForm</a>
</TD>
<TD>
  <P>Returns the 
    <code>FORM</code> element containing this control. Returns null if this control is not within the context of a form. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-accessKey><CODE>&nbsp;accessKey</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAccessKey()'>getAccessKey</a>
<a href='#setAccessKey(java.lang.String)'>setAccessKey</a>
</TD>
<TD>
  <P>A single character access key to give access to the form control. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accesskey">accesskey attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-htmlFor><CODE>&nbsp;htmlFor</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHtmlFor()'>getHtmlFor</a>
<a href='#setHtmlFor(java.lang.String)'>setHtmlFor</a>
</TD>
<TD>
  <P>This attribute links this label with another form control by 
    <code>id</code> attribute. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-for">for attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLLabelElement
extends HTMLElement
{
	/**
	 * Returns the value of the <code><a href=#att-form>form</a></code> property.
	*/
	HTMLFormElement getForm ();


	/** Assigns the value of the <code><a href=#att-accessKey>accessKey</a></code> property.
	 */
	void setAccessKey (String accessKey);

	/**
	 * Returns the value of the <code><a href=#att-accessKey>accessKey</a></code> property.
	*/
	String getAccessKey ();


	/** Assigns the value of the <code><a href=#att-htmlFor>htmlFor</a></code> property.
	 */
	void setHtmlFor (String htmlFor);

	/**
	 * Returns the value of the <code><a href=#att-htmlFor>htmlFor</a></code> property.
	*/
	String getHtmlFor ();


}
