// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>A row in a table. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-TR">TR element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rowIndex><CODE>&nbsp;rowIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRowIndex()'>getRowIndex</a>
<a href='#setRowIndex(java.lang.String)'>setRowIndex</a>
</TD>
<TD>
  <P>The index of this row, relative to the entire table. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-sectionRowIndex><CODE>&nbsp;sectionRowIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSectionRowIndex()'>getSectionRowIndex</a>
<a href='#setSectionRowIndex(java.lang.String)'>setSectionRowIndex</a>
</TD>
<TD>
  <P>The index of this row, relative to the current section (
    <code>THEAD</code>, 
    <code>TFOOT</code>, or 
    <code>TBODY</code>). 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-cells><CODE>&nbsp;cells</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCells()'>getCells</a>
<a href='#setCells(java.lang.String)'>setCells</a>
</TD>
<TD>
  <P>The collection of cells in this row. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Horizontal alignment of data within cells of this row. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TD">align attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-bgColor><CODE>&nbsp;bgColor</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBgColor()'>getBgColor</a>
<a href='#setBgColor(java.lang.String)'>setBgColor</a>
</TD>
<TD>
  <P>Background color for rows. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">bgcolor attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-ch><CODE>&nbsp;ch</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCh()'>getCh</a>
<a href='#setCh(java.lang.String)'>setCh</a>
</TD>
<TD>
  <P>Alignment character for cells in a column. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-char">char attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-chOff><CODE>&nbsp;chOff</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getChOff()'>getChOff</a>
<a href='#setChOff(java.lang.String)'>setChOff</a>
</TD>
<TD>
  <P>Offset of alignment character. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-charoff">charoff attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-vAlign><CODE>&nbsp;vAlign</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getVAlign()'>getVAlign</a>
<a href='#setVAlign(java.lang.String)'>setVAlign</a>
</TD>
<TD>
  <P>Vertical alignment of data within cells of this row. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-valign">valign attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLTableRowElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-rowIndex>rowIndex</a></code> property.
	 */
	void setRowIndex (int rowIndex);

	/**
	 * Returns the value of the <code><a href=#att-rowIndex>rowIndex</a></code> property.
	*/
	int getRowIndex ();


	/** Assigns the value of the <code><a href=#att-sectionRowIndex>sectionRowIndex</a></code> property.
	 */
	void setSectionRowIndex (int sectionRowIndex);

	/**
	 * Returns the value of the <code><a href=#att-sectionRowIndex>sectionRowIndex</a></code> property.
	*/
	int getSectionRowIndex ();


	/** Assigns the value of the <code><a href=#att-cells>cells</a></code> property.
	 */
	void setCells (HTMLCollection cells);

	/**
	 * Returns the value of the <code><a href=#att-cells>cells</a></code> property.
	*/
	HTMLCollection getCells ();


	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-bgColor>bgColor</a></code> property.
	 */
	void setBgColor (String bgColor);

	/**
	 * Returns the value of the <code><a href=#att-bgColor>bgColor</a></code> property.
	*/
	String getBgColor ();


	/** Assigns the value of the <code><a href=#att-ch>ch</a></code> property.
	 */
	void setCh (String ch);

	/**
	 * Returns the value of the <code><a href=#att-ch>ch</a></code> property.
	*/
	String getCh ();


	/** Assigns the value of the <code><a href=#att-chOff>chOff</a></code> property.
	 */
	void setChOff (String chOff);

	/**
	 * Returns the value of the <code><a href=#att-chOff>chOff</a></code> property.
	*/
	String getChOff ();


	/** Assigns the value of the <code><a href=#att-vAlign>vAlign</a></code> property.
	 */
	void setVAlign (String vAlign);

	/**
	 * Returns the value of the <code><a href=#att-vAlign>vAlign</a></code> property.
	*/
	String getVAlign ();


/**

  <P>Insert an empty 
    <code>TD</code> cell into this row.
  
</P>

@return The newly created cell.
@param index
The place to insert the cell.
*/
HTMLElement insertCell (int index);

/**

  <P>Delete a cell from the current row.
</P>

@param index
The index of the cell to delete.
*/
void deleteCell (int index);

}
