/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.context.model;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.util.SaFoxUtil;

public interface SaRequest {
    public Object getSource();

    public String getParam(String var1);

    default public String getParam(String name, String defaultValue) {
        String value = this.getParam(name);
        if (SaFoxUtil.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    default public boolean isParam(String name, String value) {
        String paramValue = this.getParam(name);
        return SaFoxUtil.isNotEmpty(paramValue) && paramValue.equals(value);
    }

    default public boolean hasParam(String name) {
        return SaFoxUtil.isNotEmpty(this.getParam(name));
    }

    default public String getParamNotNull(String name) {
        String paramValue = this.getParam(name);
        if (SaFoxUtil.isEmpty(paramValue)) {
            throw new SaTokenException("\u7f3a\u5c11\u53c2\u6570\uff1a" + name);
        }
        return paramValue;
    }

    public String getHeader(String var1);

    default public String getHeader(String name, String defaultValue) {
        String value = this.getHeader(name);
        if (SaFoxUtil.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public String getCookieValue(String var1);

    public String getRequestPath();

    default public boolean isPath(String path) {
        return this.getRequestPath().equals(path);
    }

    public String getUrl();

    public String getMethod();

    default public boolean isAjax() {
        return this.getHeader("X-Requested-With") != null;
    }

    default public Object forward(String path) {
        throw new SaTokenException("No implementation");
    }
}

