/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.log;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.log.SaLog;
import cn.dev33.satoken.util.StrFormatter;

public class SaLogForConsole
implements SaLog {
    public static final int trace = 1;
    public static final int debug = 2;
    public static final int info = 3;
    public static final int warn = 4;
    public static final int error = 5;
    public static final int fatal = 6;
    public static String LOG_PREFIX = "SaLog -->: ";
    public static String TRACE_PREFIX = "SA [TRACE]-->: ";
    public static String DEBUG_PREFIX = "SA [DEBUG]-->: ";
    public static String INFO_PREFIX = "SA [INFO] -->: ";
    public static String WARN_PREFIX = "SA [WARN] -->: ";
    public static String ERROR_PREFIX = "SA [ERROR]-->: ";
    public static String FATAL_PREFIX = "SA [FATAL]-->: ";
    public static String TRACE_COLOR = "\u001b[39m";
    public static String DEBUG_COLOR = "\u001b[34m";
    public static String INFO_COLOR = "\u001b[32m";
    public static String WARN_COLOR = "\u001b[33m";
    public static String ERROR_COLOR = "\u001b[31m";
    public static String FATAL_COLOR = "\u001b[35m";
    public static String DEFAULT_COLOR = "\u001b[39m";

    @Override
    public void trace(String str, Object ... args) {
        this.println(1, TRACE_COLOR, TRACE_PREFIX, str, args);
    }

    @Override
    public void debug(String str, Object ... args) {
        this.println(2, DEBUG_COLOR, DEBUG_PREFIX, str, args);
    }

    @Override
    public void info(String str, Object ... args) {
        this.println(3, INFO_COLOR, INFO_PREFIX, str, args);
    }

    @Override
    public void warn(String str, Object ... args) {
        this.println(4, WARN_COLOR, WARN_PREFIX, str, args);
    }

    @Override
    public void error(String str, Object ... args) {
        this.println(5, ERROR_COLOR, ERROR_PREFIX, str, args);
    }

    @Override
    public void fatal(String str, Object ... args) {
        this.println(6, FATAL_COLOR, FATAL_PREFIX, str, args);
    }

    public void println(int level, String color, String prefix, String str, Object ... args) {
        SaTokenConfig config = SaManager.getConfig();
        if (config.getIsLog().booleanValue() && level >= config.getLogLevelInt()) {
            if (config.getIsColorLog() == Boolean.TRUE) {
                System.out.println(color + prefix + StrFormatter.format(str, args) + DEFAULT_COLOR);
            } else {
                System.out.println(prefix + StrFormatter.format(str, args));
            }
        }
    }
}

