/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaTokenConfig;
import java.util.LinkedHashMap;
import java.util.Map;

public class SaLoginModel {
    public String device;
    public Boolean isLastingCookie = true;
    public Long timeout;
    private Long activeTimeout;
    public Map<String, Object> extraData;
    public String token;
    private Boolean isWriteHeader;
    private Object tokenSignTag;

    public String getDevice() {
        return this.device;
    }

    public SaLoginModel setDevice(String device) {
        this.device = device;
        return this;
    }

    public Boolean getIsLastingCookie() {
        return this.isLastingCookie;
    }

    public SaLoginModel setIsLastingCookie(Boolean isLastingCookie) {
        this.isLastingCookie = isLastingCookie;
        return this;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public SaLoginModel setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public Long getActiveTimeout() {
        return this.activeTimeout;
    }

    public SaLoginModel setActiveTimeout(long activeTimeout) {
        this.activeTimeout = activeTimeout;
        return this;
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public SaLoginModel setExtraData(Map<String, Object> extraData) {
        this.extraData = extraData;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public SaLoginModel setToken(String token) {
        this.token = token;
        return this;
    }

    public Boolean getIsWriteHeader() {
        return this.isWriteHeader;
    }

    public SaLoginModel setIsWriteHeader(Boolean isWriteHeader) {
        this.isWriteHeader = isWriteHeader;
        return this;
    }

    public Object getTokenSignTag() {
        return this.tokenSignTag;
    }

    public SaLoginModel setTokenSignTag(Object tokenSignTag) {
        this.tokenSignTag = tokenSignTag;
        return this;
    }

    public String toString() {
        return "SaLoginModel [device=" + this.device + ", isLastingCookie=" + this.isLastingCookie + ", timeout=" + this.timeout + ", activeTimeout=" + this.activeTimeout + ", extraData=" + this.extraData + ", token=" + this.token + ", isWriteHeader=" + this.isWriteHeader + ", tokenSignTag=" + this.tokenSignTag + "]";
    }

    public Boolean getIsLastingCookieOrFalse() {
        if (this.isLastingCookie == null) {
            return false;
        }
        return this.isLastingCookie;
    }

    public SaLoginModel setExtra(String key, Object value) {
        if (this.extraData == null) {
            this.extraData = new LinkedHashMap<String, Object>();
        }
        this.extraData.put(key, value);
        return this;
    }

    public Object getExtra(String key) {
        if (this.extraData == null) {
            return null;
        }
        return this.extraData.get(key);
    }

    public boolean isSetExtraData() {
        return this.extraData != null && this.extraData.size() != 0;
    }

    public int getCookieTimeout() {
        if (!this.getIsLastingCookieOrFalse().booleanValue()) {
            return -1;
        }
        long _timeout = this.getTimeout();
        if (_timeout == -1L || _timeout > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)_timeout;
    }

    public String getDeviceOrDefault() {
        if (this.device == null) {
            return "default-device";
        }
        return this.device;
    }

    public SaLoginModel build() {
        return this.build(SaManager.getConfig());
    }

    public SaLoginModel build(SaTokenConfig config) {
        if (this.timeout == null) {
            this.timeout = config.getTimeout();
        }
        if (this.isWriteHeader == null) {
            this.isWriteHeader = config.getIsWriteHeader();
        }
        return this;
    }

    public static SaLoginModel create() {
        return new SaLoginModel();
    }

    @Deprecated
    public Long getTimeoutOrGlobalConfig() {
        if (this.timeout == null) {
            this.timeout = SaManager.getConfig().getTimeout();
        }
        return this.timeout;
    }

    @Deprecated
    public Boolean getIsWriteHeaderOrGlobalConfig() {
        if (this.isWriteHeader == null) {
            this.isWriteHeader = SaManager.getConfig().getIsWriteHeader();
        }
        return this.isWriteHeader;
    }
}

