/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.scope.handler;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.jwt.SaJwtUtil;
import cn.dev33.satoken.jwt.exception.SaJwtException;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.oidc.IdTokenModel;
import cn.dev33.satoken.oauth2.data.model.request.ClientIdAndSecretModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.scope.handler.SaOAuth2ScopeHandlerInterface;
import cn.dev33.satoken.sign.SaSignManager;
import cn.dev33.satoken.util.SaFoxUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;

public class OidcScopeHandler
implements SaOAuth2ScopeHandlerInterface {
    @Override
    public String getHandlerScope() {
        return "oidc";
    }

    @Override
    public void workAccessToken(AccessTokenModel at) {
        SaRequest req = SaHolder.getRequest();
        ClientIdAndSecretModel client = SaOAuth2Manager.getDataResolver().readClientIdAndSecret(req);
        IdTokenModel idToken = new IdTokenModel();
        idToken.iss = this.getIss();
        idToken.sub = at.loginId;
        idToken.aud = client.clientId;
        idToken.iat = System.currentTimeMillis() / 1000L;
        idToken.exp = idToken.iat + SaOAuth2Manager.getServerConfig().getOidc().getIdTokenTimeout();
        idToken.authTime = SaOAuth2Manager.getStpLogic().getSessionByLoginId(at.loginId).getCreateTime() / 1000L;
        idToken.nonce = this.getNonce();
        idToken.acr = null;
        idToken.amr = null;
        idToken.azp = client.clientId;
        idToken.extraData = new LinkedHashMap<String, Object>();
        idToken = this.workExtraData(idToken);
        String jwtIdToken = this.generateJwtIdToken(idToken);
        at.extraData.put("id_token", jwtIdToken);
    }

    @Override
    public void workClientToken(ClientTokenModel ct) {
    }

    @Override
    public boolean refreshAccessTokenIsWork() {
        return true;
    }

    public String getIss() {
        String cfgIss = SaOAuth2Manager.getServerConfig().getOidc().getIss();
        if (SaFoxUtil.isNotEmpty((Object)cfgIss)) {
            return cfgIss;
        }
        String urlString = SaHolder.getRequest().getUrl();
        try {
            URL url = new URL(urlString);
            String iss = url.getProtocol() + "://" + url.getHost();
            if (url.getPort() != -1) {
                iss = iss + ":" + url.getPort();
            }
            return iss;
        }
        catch (MalformedURLException e) {
            throw new SaOAuth2Exception(e);
        }
    }

    public String getNonce() {
        String nonce = SaHolder.getRequest().getParam(SaOAuth2Consts.Param.nonce);
        if (SaFoxUtil.isEmpty((Object)nonce)) {
            nonce = SaOAuth2Manager.getDao().getNonce(SaHolder.getRequest().getParam(SaOAuth2Consts.Param.code));
        }
        if (SaFoxUtil.isEmpty((Object)nonce)) {
            nonce = SaFoxUtil.getRandomString((int)32);
        }
        SaSignManager.getSaSignTemplate().checkNonce(nonce);
        return nonce;
    }

    public IdTokenModel workExtraData(IdTokenModel idToken) {
        return idToken;
    }

    public Map<String, Object> convertIdTokenToMap(IdTokenModel idToken) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("iss", idToken.iss);
        map.put("sub", idToken.sub);
        map.put("aud", idToken.aud);
        map.put("exp", idToken.exp);
        map.put("iat", idToken.iat);
        map.put("auth_time", idToken.authTime);
        map.put("nonce", idToken.nonce);
        map.put("acr", idToken.acr);
        map.put("amr", idToken.amr);
        map.put("azp", idToken.azp);
        idToken.extraData.entrySet().removeIf(entry -> entry.getValue() == null);
        map.putAll(idToken.extraData);
        return map;
    }

    public String generateJwtIdToken(IdTokenModel idToken) {
        Map<String, Object> dataMap = this.convertIdTokenToMap(idToken);
        String keyt = SaOAuth2Manager.getStpLogic().getConfigOrGlobal().getJwtSecretKey();
        SaJwtException.throwByNull((Object)keyt, (String)"\u8bf7\u914d\u7f6ejwt\u79d8\u94a5", (int)30205);
        return SaJwtUtil.createToken(dataMap, (String)keyt);
    }
}

