/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.strategy;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.fun.SaParamFunction;
import cn.dev33.satoken.fun.SaTwoParamFunction;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.config.SaOAuth2ServerConfig;
import cn.dev33.satoken.oauth2.consts.GrantType;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.data.model.request.ClientIdAndSecretModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.function.SaOAuth2ConfirmViewFunction;
import cn.dev33.satoken.oauth2.function.SaOAuth2DoLoginHandleFunction;
import cn.dev33.satoken.oauth2.function.SaOAuth2NotLoginViewFunction;
import cn.dev33.satoken.oauth2.function.strategy.SaOAuth2CreateAccessTokenValueFunction;
import cn.dev33.satoken.oauth2.function.strategy.SaOAuth2CreateClientTokenValueFunction;
import cn.dev33.satoken.oauth2.function.strategy.SaOAuth2CreateCodeValueFunction;
import cn.dev33.satoken.oauth2.function.strategy.SaOAuth2CreateRefreshTokenValueFunction;
import cn.dev33.satoken.oauth2.function.strategy.SaOAuth2GrantTypeAuthFunction;
import cn.dev33.satoken.oauth2.function.strategy.SaOAuth2ScopeWorkAccessTokenFunction;
import cn.dev33.satoken.oauth2.function.strategy.SaOAuth2ScopeWorkClientTokenFunction;
import cn.dev33.satoken.oauth2.granttype.handler.AuthorizationCodeGrantTypeHandler;
import cn.dev33.satoken.oauth2.granttype.handler.PasswordGrantTypeHandler;
import cn.dev33.satoken.oauth2.granttype.handler.RefreshTokenGrantTypeHandler;
import cn.dev33.satoken.oauth2.granttype.handler.SaOAuth2GrantTypeHandlerInterface;
import cn.dev33.satoken.oauth2.scope.handler.OidcScopeHandler;
import cn.dev33.satoken.oauth2.scope.handler.OpenIdScopeHandler;
import cn.dev33.satoken.oauth2.scope.handler.SaOAuth2ScopeHandlerInterface;
import cn.dev33.satoken.oauth2.scope.handler.UnionIdScopeHandler;
import cn.dev33.satoken.oauth2.scope.handler.UserIdScopeHandler;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SaOAuth2Strategy {
    public static final SaOAuth2Strategy instance = new SaOAuth2Strategy();
    public Map<String, SaOAuth2ScopeHandlerInterface> scopeHandlerMap = new LinkedHashMap<String, SaOAuth2ScopeHandlerInterface>();
    public SaOAuth2ScopeWorkAccessTokenFunction workAccessTokenByScope = at -> {
        SaOAuth2ScopeHandlerInterface finallyWorkScopeHandler;
        if (at.scopes != null && !at.scopes.isEmpty()) {
            for (String scope : at.scopes) {
                SaOAuth2ScopeHandlerInterface handler = this.scopeHandlerMap.get(scope);
                if (handler == null) continue;
                handler.workAccessToken((AccessTokenModel)at);
            }
        }
        if ((finallyWorkScopeHandler = this.scopeHandlerMap.get("_FINALLY_WORK_SCOPE")) != null) {
            finallyWorkScopeHandler.workAccessToken((AccessTokenModel)at);
        }
    };
    public SaOAuth2ScopeWorkAccessTokenFunction refreshAccessTokenWorkByScope = at -> {
        SaOAuth2ScopeHandlerInterface finallyWorkScopeHandler;
        if (at.scopes != null && !at.scopes.isEmpty()) {
            for (String scope : at.scopes) {
                SaOAuth2ScopeHandlerInterface handler = this.scopeHandlerMap.get(scope);
                if (handler == null || !handler.refreshAccessTokenIsWork()) continue;
                handler.workAccessToken((AccessTokenModel)at);
            }
        }
        if ((finallyWorkScopeHandler = this.scopeHandlerMap.get("_FINALLY_WORK_SCOPE")) != null && finallyWorkScopeHandler.refreshAccessTokenIsWork()) {
            finallyWorkScopeHandler.workAccessToken((AccessTokenModel)at);
        }
    };
    public SaOAuth2ScopeWorkClientTokenFunction workClientTokenByScope = ct -> {
        SaOAuth2ScopeHandlerInterface finallyWorkScopeHandler;
        if (ct.scopes != null && !ct.scopes.isEmpty()) {
            for (String scope : ct.scopes) {
                SaOAuth2ScopeHandlerInterface handler = this.scopeHandlerMap.get(scope);
                if (handler == null) continue;
                handler.workClientToken((ClientTokenModel)ct);
            }
        }
        if ((finallyWorkScopeHandler = this.scopeHandlerMap.get("_FINALLY_WORK_SCOPE")) != null) {
            finallyWorkScopeHandler.workClientToken((ClientTokenModel)ct);
        }
    };
    public Map<String, SaOAuth2GrantTypeHandlerInterface> grantTypeHandlerMap = new LinkedHashMap<String, SaOAuth2GrantTypeHandlerInterface>();
    public SaOAuth2GrantTypeAuthFunction grantTypeAuth = req -> {
        String grantType = req.getParamNotNull(SaOAuth2Consts.Param.grant_type);
        SaOAuth2GrantTypeHandlerInterface grantTypeHandler = this.grantTypeHandlerMap.get(grantType);
        if (grantTypeHandler == null) {
            throw new SaOAuth2Exception("\u65e0\u6548 grant_type: " + grantType).setCode(30126);
        }
        SaOAuth2ServerConfig config = SaOAuth2Manager.getServerConfig();
        if (grantType.equals(GrantType.authorization_code) && !config.getEnableAuthorizationCode().booleanValue()) {
            throw new SaOAuth2Exception("\u7cfb\u7edf\u672a\u5f00\u653e\u7684 grant_type: " + grantType).setCode(30126);
        }
        if (grantType.equals(GrantType.password) && !config.getEnablePassword().booleanValue()) {
            throw new SaOAuth2Exception("\u7cfb\u7edf\u672a\u5f00\u653e\u7684 grant_type: " + grantType).setCode(30126);
        }
        ClientIdAndSecretModel clientIdAndSecretModel = SaOAuth2Manager.getDataResolver().readClientIdAndSecret((SaRequest)req);
        List<String> scopes = SaOAuth2Manager.getDataConverter().convertScopeStringToList(req.getParam(SaOAuth2Consts.Param.scope));
        SaClientModel clientModel = SaOAuth2Manager.getTemplate().checkClientSecretAndScope(clientIdAndSecretModel.getClientId(), clientIdAndSecretModel.getClientSecret(), scopes);
        if (!clientModel.getAllowGrantTypes().contains(grantType)) {
            throw new SaOAuth2Exception("\u5e94\u7528\u672a\u5f00\u653e\u7684 grant_type: " + grantType).setCode(30141);
        }
        return grantTypeHandler.getAccessToken((SaRequest)req, clientIdAndSecretModel.getClientId(), scopes);
    };
    public SaOAuth2CreateCodeValueFunction createCodeValue = (clientId, loginId, scopes) -> SaFoxUtil.getRandomString((int)60);
    public SaOAuth2CreateAccessTokenValueFunction createAccessToken = (clientId, loginId, scopes) -> SaFoxUtil.getRandomString((int)60);
    public SaOAuth2CreateRefreshTokenValueFunction createRefreshToken = (clientId, loginId, scopes) -> SaFoxUtil.getRandomString((int)60);
    public SaOAuth2CreateClientTokenValueFunction createClientToken = (clientId, scopes) -> SaFoxUtil.getRandomString((int)60);
    public SaOAuth2NotLoginViewFunction notLoginView = () -> "\u5f53\u524d\u4f1a\u8bdd\u5728 OAuth-Server \u8ba4\u8bc1\u4e2d\u5fc3\u5c1a\u672a\u767b\u5f55";
    public SaOAuth2ConfirmViewFunction confirmView = (clientId, scopes) -> "\u672c\u6b21\u64cd\u4f5c\u9700\u8981\u7528\u6237\u6388\u6743";
    public SaOAuth2DoLoginHandleFunction doLoginHandle = (name, pwd) -> SaResult.error();
    public SaTwoParamFunction<Object, String> userAuthorizeClientCheck = (loginId, clientId) -> {};
    public SaParamFunction<SaClientModel> setSaClientModelDefaultFields = clientModel -> {
        SaOAuth2ServerConfig config = SaOAuth2Manager.getServerConfig();
        clientModel.accessTokenTimeout = config.getAccessTokenTimeout();
        clientModel.refreshTokenTimeout = config.getRefreshTokenTimeout();
        clientModel.clientTokenTimeout = config.getClientTokenTimeout();
        clientModel.maxAccessTokenCount = config.getMaxAccessTokenCount();
        clientModel.maxRefreshTokenCount = config.getMaxRefreshTokenCount();
        clientModel.maxClientTokenCount = config.getMaxClientTokenCount();
        clientModel.isNewRefresh = config.getIsNewRefresh();
    };

    private SaOAuth2Strategy() {
        this.registerDefaultScopeHandler();
        this.registerDefaultGrantTypeHandler();
    }

    public void registerDefaultScopeHandler() {
        this.scopeHandlerMap.put("openid", new OpenIdScopeHandler());
        this.scopeHandlerMap.put("unionid", new UnionIdScopeHandler());
        this.scopeHandlerMap.put("userid", new UserIdScopeHandler());
        this.scopeHandlerMap.put("oidc", new OidcScopeHandler());
    }

    public void registerScopeHandler(SaOAuth2ScopeHandlerInterface handler) {
        this.scopeHandlerMap.put(handler.getHandlerScope(), handler);
        SaManager.getLog().info("\u81ea\u5b9a\u4e49 SCOPE [{}] (\u5904\u7406\u5668: {})", new Object[]{handler.getHandlerScope(), handler.getClass().getCanonicalName()});
    }

    public void removeScopeHandler(String scope) {
        this.scopeHandlerMap.remove(scope);
    }

    public void registerDefaultGrantTypeHandler() {
        this.grantTypeHandlerMap.put(GrantType.authorization_code, new AuthorizationCodeGrantTypeHandler());
        this.grantTypeHandlerMap.put(GrantType.password, new PasswordGrantTypeHandler());
        this.grantTypeHandlerMap.put(GrantType.refresh_token, new RefreshTokenGrantTypeHandler());
    }

    public void registerGrantTypeHandler(SaOAuth2GrantTypeHandlerInterface handler) {
        this.grantTypeHandlerMap.put(handler.getHandlerGrantType(), handler);
        SaManager.getLog().info("\u81ea\u5b9a\u4e49 GRANT_TYPE [{}] (\u5904\u7406\u5668: {})", new Object[]{handler.getHandlerGrantType(), handler.getClass().getCanonicalName()});
    }

    public void removeGrantTypeHandler(String scope) {
        this.scopeHandlerMap.remove(scope);
    }
}

