/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.reactor.filter;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.FirewallCheckException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.reactor.context.SaReactorSyncHolder;
import cn.dev33.satoken.reactor.model.SaRequestForReactor;
import cn.dev33.satoken.reactor.model.SaResponseForReactor;
import cn.dev33.satoken.reactor.util.SaReactorOperateUtil;
import cn.dev33.satoken.strategy.SaFirewallStrategy;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-102)
public class SaFirewallCheckFilterForReactor
implements WebFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        SaRequestForReactor saRequest = new SaRequestForReactor(exchange.getRequest());
        SaResponseForReactor saResponse = new SaResponseForReactor(exchange.getResponse());
        try {
            SaReactorSyncHolder.setContext(exchange);
            SaFirewallStrategy.instance.check.execute((SaRequest)saRequest, (SaResponse)saResponse, (Object)exchange);
        }
        catch (StopMatchException stopMatchException) {
        }
        catch (BackResultException e) {
            Mono<Void> mono = SaReactorOperateUtil.writeResult(exchange, e.getMessage());
            return mono;
        }
        catch (FirewallCheckException e) {
            if (SaFirewallStrategy.instance.checkFailHandle == null) {
                Mono<Void> mono = SaReactorOperateUtil.writeResult(exchange, e.getMessage());
                return mono;
            }
            SaFirewallStrategy.instance.checkFailHandle.run(e, (SaRequest)saRequest, (SaResponse)saResponse, null);
            Mono mono = Mono.empty();
            return mono;
        }
        finally {
            SaReactorSyncHolder.clearContext();
        }
        return chain.filter(exchange);
    }
}

