/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.GlobalHeaders;
import cn.hutool.http.Header;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.http.ssl.SSLSocketFactoryBuilder;
import cn.hutool.json.JSON;
import cn.hutool.log.StaticLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest
extends HttpBase<HttpRequest> {
    public static final int TIMEOUT_DEFAULT = -1;
    private static final String BOUNDARY = "--------------------Hutool_" + RandomUtil.randomString((int)16);
    private static final byte[] BOUNDARY_END = StrUtil.format((CharSequence)"--{}--\r\n", (Object[])new Object[]{BOUNDARY}).getBytes();
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_X_WWW_FORM_URLENCODED_PREFIX = "application/x-www-form-urlencoded;charset=";
    private static final String CONTENT_TYPE_MULTIPART_PREFIX = "multipart/form-data; boundary=";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n\r\n";
    private String url;
    private Method method = Method.GET;
    private int timeout = -1;
    private Map<String, Object> form;
    private Map<String, DataSource> fileForm;
    private String cookie;
    private HttpConnection httpConnection;
    private boolean isDisableCache;
    private boolean isEncodeUrl;
    private int redirectCount;
    private int maxRedirectCount;
    private Proxy proxy;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory ssf;

    public HttpRequest(String url) {
        Assert.notBlank((String)url, (String)"Param [url] can not be blank !", (Object[])new Object[0]);
        this.url = url;
        this.header(GlobalHeaders.INSTANCE.headers);
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return new HttpRequest(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return new HttpRequest(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return new HttpRequest(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(url).method(Method.PUT);
    }

    public static HttpRequest patch(String url) {
        return new HttpRequest(url).method(Method.PATCH);
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return new HttpRequest(url).method(Method.TRACE);
    }

    public HttpRequest contentType(String contentType) {
        this.header(Header.CONTENT_TYPE, contentType);
        return this;
    }

    public HttpRequest keepAlive(boolean isKeepAlive) {
        this.header(Header.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return this;
    }

    public boolean isKeepAlive() {
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase("HTTP/1.0");
        }
        return !connection.equalsIgnoreCase("close");
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    public HttpRequest contentLength(int value) {
        this.header(Header.CONTENT_LENGTH, String.valueOf(value));
        return this;
    }

    public HttpRequest cookie(HttpCookie ... cookies) {
        if (ArrayUtil.isEmpty((Object[])cookies)) {
            return this.disableCookie();
        }
        return this.cookie(ArrayUtil.join((Object[])cookies, (CharSequence)";"));
    }

    public HttpRequest cookie(String cookie) {
        this.cookie = cookie;
        return this;
    }

    public HttpRequest disableCookie() {
        return this.cookie("");
    }

    public HttpRequest enableDefaultCookie() {
        return this.cookie((String)null);
    }

    public HttpRequest form(String name, Object value) {
        if (StrUtil.isBlank((CharSequence)name) || ObjectUtil.isNull((Object)value)) {
            return this;
        }
        this.bodyBytes = null;
        if (value instanceof File) {
            return this.form(name, (File)value);
        }
        if (value instanceof DataSource) {
            return this.form(name, (DataSource)value);
        }
        if (this.form == null) {
            this.form = new HashMap<String, Object>();
        }
        String strValue = value instanceof List ? CollectionUtil.join((Iterable)((List)value), (CharSequence)",") : (ArrayUtil.isArray((Object)value) ? ArrayUtil.join((Object[])((Object[])value), (CharSequence)",") : Convert.toStr((Object)value, null));
        this.form.put(name, strValue);
        return this;
    }

    public HttpRequest form(String name, Object value, Object ... parameters) {
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form(name, parameters[i + 1]);
        }
        return this;
    }

    public HttpRequest form(Map<String, Object> formMap) {
        if (MapUtil.isNotEmpty(formMap)) {
            for (Map.Entry<String, Object> entry : formMap.entrySet()) {
                this.form(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public HttpRequest form(String name, File file) {
        if (null != file) {
            this.form(name, (DataSource)new FileDataSource(file));
        }
        return this;
    }

    public HttpRequest form(String name, DataSource dataSource) {
        if (null != dataSource) {
            if (!this.isKeepAlive()) {
                this.keepAlive(true);
            }
            if (null == this.fileForm) {
                this.fileForm = new HashMap<String, DataSource>();
            }
            this.fileForm.put(name, dataSource);
        }
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public Map<String, DataSource> fileForm() {
        return this.fileForm;
    }

    public HttpRequest body(String body) {
        return this.body(body, null);
    }

    public HttpRequest body(String body, String contentType) {
        this.body(StrUtil.bytes((CharSequence)body, (Charset)this.charset));
        this.form = null;
        this.contentLength(null != body ? body.length() : 0);
        if (null != contentType) {
            this.contentType(contentType);
        } else if (null == this.header(Header.CONTENT_TYPE) && null != (contentType = HttpUtil.getContentTypeByRequestBody(body))) {
            this.contentType(contentType);
        }
        return this;
    }

    public HttpRequest body(JSON json) {
        this.body(json.toString());
        String contentTypeJson = "application/json";
        if (null != this.charset) {
            contentTypeJson = StrUtil.format((CharSequence)"{};charset={}", (Object[])new Object[]{contentTypeJson, this.charset.name()});
        }
        this.contentType(contentTypeJson);
        return this;
    }

    public HttpRequest body(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
        return this;
    }

    public HttpRequest timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public HttpRequest disableCache() {
        this.isDisableCache = true;
        return this;
    }

    public HttpRequest setEncodeUrl(boolean isEncodeUrl) {
        this.isEncodeUrl = isEncodeUrl;
        return this;
    }

    public HttpRequest setFollowRedirects(Boolean isFollowRedirects) {
        return this.setMaxRedirectCount(2);
    }

    public HttpRequest setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = maxRedirectCount > 0 ? maxRedirectCount : 0;
        return this;
    }

    public HttpRequest setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HttpRequest setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpRequest setSSLSocketFactory(SSLSocketFactory ssf) {
        this.ssf = ssf;
        return this;
    }

    public HttpRequest setSSLProtocol(String protocol) {
        if (null == this.ssf) {
            try {
                this.ssf = SSLSocketFactoryBuilder.create().setProtocol(protocol).build();
            }
            catch (Exception e) {
                throw new HttpException(e);
            }
        }
        return this;
    }

    public HttpResponse execute() {
        return this.execute(false);
    }

    public HttpResponse executeAsync() {
        return this.execute(true);
    }

    public HttpResponse execute(boolean isAsync) {
        this.urlWithParamIfGet();
        this.initConnecton();
        this.send();
        HttpResponse httpResponse = this.sendRedirectIfPosible();
        if (null == httpResponse) {
            httpResponse = new HttpResponse(this.httpConnection, this.charset, isAsync, this.isIgnoreResponseBody());
        }
        return httpResponse;
    }

    public HttpRequest basicAuth(String username, String password) {
        String data = username.concat(":").concat(password);
        String base64 = Base64.encode((String)data, (Charset)this.charset);
        this.header("Authorization", "Basic " + base64, true);
        return this;
    }

    private void initConnecton() {
        this.httpConnection = HttpConnection.create(this.url, this.method, this.hostnameVerifier, this.ssf, this.timeout, this.proxy).header(this.headers, true);
        if (null != this.cookie) {
            this.httpConnection.setCookie(this.cookie);
        }
        if (this.isDisableCache) {
            this.httpConnection.disableCache();
        }
        this.httpConnection.setInstanceFollowRedirects(this.maxRedirectCount > 0);
    }

    private void urlWithParamIfGet() {
        if (Method.GET.equals((Object)this.method)) {
            this.url = ArrayUtil.isNotEmpty((byte[])this.bodyBytes) ? HttpUtil.urlWithForm(this.url, StrUtil.str((byte[])this.bodyBytes, (Charset)this.charset), this.charset, this.isEncodeUrl) : HttpUtil.urlWithForm(this.url, this.form, this.charset, this.isEncodeUrl);
        }
    }

    private HttpResponse sendRedirectIfPosible() {
        if (this.maxRedirectCount < 1) {
            return null;
        }
        if (this.httpConnection.getHttpURLConnection().getInstanceFollowRedirects()) {
            int responseCode;
            try {
                responseCode = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                throw new HttpException(e);
            }
            if (responseCode != 200 && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
                this.url = this.httpConnection.header(Header.LOCATION);
                if (this.redirectCount < this.maxRedirectCount) {
                    ++this.redirectCount;
                    return this.execute();
                }
                StaticLog.warn((String)"URL [{}] redirect count more than two !", (Object[])new Object[]{this.url});
            }
        }
        return null;
    }

    private void send() throws HttpException {
        try {
            if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method)) {
                if (CollectionUtil.isEmpty(this.fileForm)) {
                    this.sendFormUrlEncoded();
                } else {
                    this.sendMltipart();
                }
            } else {
                this.httpConnection.connect();
            }
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage(), e);
        }
    }

    private void sendFormUrlEncoded() throws IOException {
        if (StrUtil.isBlank((CharSequence)this.header(Header.CONTENT_TYPE))) {
            this.httpConnection.header(Header.CONTENT_TYPE, CONTENT_TYPE_X_WWW_FORM_URLENCODED_PREFIX + this.charset, true);
        }
        if (ArrayUtil.isNotEmpty((byte[])this.bodyBytes)) {
            IoUtil.write((OutputStream)this.httpConnection.getOutputStream(), (boolean)true, (byte[])this.bodyBytes);
        } else {
            String content = HttpUtil.toParams(this.form, this.charset);
            IoUtil.write((OutputStream)this.httpConnection.getOutputStream(), (Charset)this.charset, (boolean)true, (Object[])new Object[]{content});
        }
    }

    private void sendMltipart() throws IOException {
        this.setMultipart();
        OutputStream out = this.httpConnection.getOutputStream();
        try {
            this.writeFileForm(out);
            this.writeForm(out);
            this.formEnd(out);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IoUtil.close((Closeable)out);
        }
    }

    private void writeForm(OutputStream out) throws IOException {
        if (CollectionUtil.isNotEmpty(this.form)) {
            StringBuilder builder = StrUtil.builder();
            for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                builder.append("--").append(BOUNDARY).append("\r\n");
                builder.append(StrUtil.format((CharSequence)CONTENT_DISPOSITION_TEMPLATE, (Object[])new Object[]{entry.getKey()}));
                builder.append(entry.getValue()).append("\r\n");
            }
            IoUtil.write((OutputStream)out, (Charset)this.charset, (boolean)false, (Object[])new Object[]{builder});
        }
    }

    private void writeFileForm(OutputStream out) throws IOException {
        for (Map.Entry<String, DataSource> entry : this.fileForm.entrySet()) {
            DataSource dataSource = entry.getValue();
            StringBuilder builder = StrUtil.builder().append("--").append(BOUNDARY).append("\r\n");
            builder.append(StrUtil.format((CharSequence)CONTENT_DISPOSITION_FILE_TEMPLATE, (Object[])new Object[]{entry.getKey(), dataSource.getName()}));
            builder.append(StrUtil.format((CharSequence)CONTENT_TYPE_FILE_TEMPLATE, (Object[])new Object[]{HttpUtil.getMimeType(dataSource.getName())}));
            IoUtil.write((OutputStream)out, (Charset)this.charset, (boolean)false, (Object[])new Object[]{builder});
            IoUtil.copy((InputStream)dataSource.getInputStream(), (OutputStream)out);
            IoUtil.write((OutputStream)out, (Charset)this.charset, (boolean)false, (Object[])new Object[]{"\r\n"});
        }
    }

    private void formEnd(OutputStream out) throws IOException {
        out.write(BOUNDARY_END);
        out.flush();
    }

    private void setMultipart() {
        this.httpConnection.header(Header.CONTENT_TYPE, CONTENT_TYPE_MULTIPART_PREFIX + BOUNDARY, true);
    }

    private boolean isIgnoreResponseBody() {
        return Method.HEAD == this.method || Method.CONNECT == this.method || Method.OPTIONS == this.method || Method.TRACE == this.method;
    }
}

