/*
 * Decompiled with CFR 0.152.
 */
package io.rong.example.agent;

import io.rong.CenterEnum;
import io.rong.RongCloud;
import io.rong.methods.agent.AIAgent;
import io.rong.models.agent.AgentConfig;
import io.rong.models.agent.AgentModel;
import io.rong.models.agent.ChatModel;
import io.rong.models.agent.Memory;
import io.rong.models.agent.Model;
import io.rong.models.agent.ModelOptions;
import io.rong.models.agent.Prompt;
import io.rong.models.response.ChatAgentResult;
import io.rong.models.response.GetAIAgentResult;
import io.rong.models.response.PagingQueryAgentsResult;
import io.rong.models.response.ResponseResult;

public class AIAgentExample {
    private static final String APP_KEY = "appKey";
    private static final String APP_SECRET = "secret";
    private static AIAgent agent = RongCloud.getInstance((String)"appKey", (String)"secret", (CenterEnum)CenterEnum.BJ).agent;

    public static void main(String[] args) throws Exception {
        AIAgentExample.createTest();
        AIAgentExample.deleteTest();
        AIAgentExample.updateTest();
        AIAgentExample.getTest();
        AIAgentExample.queryListTest();
        AIAgentExample.chatTest();
    }

    private static void chatTest() throws Exception {
        ChatModel model = new ChatModel();
        model.setAgentId("test_agentg_3821633206");
        model.setMemory(true);
        model.setConversationId("test_id");
        model.setUser("uid1");
        model.setQuery("Hello");
        ChatAgentResult result = agent.chat(model);
        System.out.println("Chat to agent test:  " + result.toString());
    }

    private static void createTest() throws Exception {
        AgentModel info = new AgentModel();
        info.setAgentId("rc_agentId");
        info.setName("rc_name");
        info.setDescription("rc_description");
        info.setType("chat");
        info.setStatus("active");
        AgentConfig agentConfig = new AgentConfig();
        Model model = new Model();
        model.setProvider("openai");
        model.setName("qwen-turbo");
        ModelOptions modelOptions = new ModelOptions();
        model.setOptions(modelOptions);
        agentConfig.setModel(model);
        Prompt prompt = new Prompt();
        agentConfig.setPrompt(prompt);
        Memory memory = new Memory();
        memory.setStrategy("sliding_window");
        memory.setMaxMessages(10);
        memory.setMaxTokens(1000);
        agentConfig.setMemory(memory);
        info.setAgentConfig(agentConfig);
        ResponseResult result = agent.create(info);
        System.out.println("create agent test:  " + result.toString());
    }

    private static void getTest() throws Exception {
        GetAIAgentResult result = agent.get("rc_agentId");
        System.out.println("update agent test:  " + result.toString());
    }

    private static void deleteTest() throws Exception {
        ResponseResult result = agent.delete("rc_agentId");
        System.out.println("delete agent test:  " + result.toString());
    }

    private static void updateTest() throws Exception {
        AgentModel info = new AgentModel();
        info.setAgentId("rc_agentId");
        info.setName("rc_name111");
        info.setDescription("rc_description111");
        info.setType("chat");
        info.setStatus("active");
        AgentConfig agentConfig = new AgentConfig();
        Model model = new Model();
        model.setProvider("openai");
        model.setName("qwen-turbo");
        ModelOptions modelOptions = new ModelOptions();
        model.setOptions(modelOptions);
        agentConfig.setModel(model);
        Prompt prompt = new Prompt();
        agentConfig.setPrompt(prompt);
        Memory memory = new Memory();
        memory.setStrategy("sliding_window");
        memory.setMaxMessages(10);
        memory.setMaxTokens(1000);
        agentConfig.setMemory(memory);
        info.setAgentConfig(agentConfig);
        ResponseResult result = agent.update(info);
        System.out.println("update agent test:  " + result.toString());
    }

    private static void queryListTest() throws Exception {
        PagingQueryAgentsResult result = agent.query(1, 2, "active", "chat");
        System.out.println("update agent test:  " + result.toString());
    }
}

