/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.agent;

import io.rong.RongCloud;
import io.rong.methods.BaseMethod;
import io.rong.models.agent.AgentModel;
import io.rong.models.agent.ChatModel;
import io.rong.models.response.ChatAgentResult;
import io.rong.models.response.GetAIAgentResult;
import io.rong.models.response.PagingQueryAgentsResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.GsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AIAgent
extends BaseMethod {
    private static final String API_JSON_PATH = "agent";

    public AIAgent(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
        this.initPath();
    }

    @Override
    protected void initPath() {
        this.path = API_JSON_PATH;
    }

    public ResponseResult create(AgentModel info) throws Exception {
        String method = "agentCreate";
        ResponseResult result = this.checkFiled(info, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/agent/create.json", info.toString(), method, ResponseResult.class, "application/json");
    }

    public GetAIAgentResult get(String agentId) throws Exception {
        String method = "agentGet";
        if (StringUtils.isBlank((CharSequence)agentId)) {
            return new GetAIAgentResult(20005, "The parameter 'agentId' is required");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("agentId", agentId);
        return this.doRequest("/v3/agent/get.json", GsonUtil.toJson(params, Map.class), method, GetAIAgentResult.class, "application/json");
    }

    public ResponseResult update(AgentModel info) throws Exception {
        String method = "agentUpdate";
        ResponseResult result = this.checkFiled(info, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/agent/update.json", info.toString(), method, ResponseResult.class, "application/json");
    }

    public ResponseResult delete(String agentId) throws Exception {
        String method = "agentDelete";
        if (StringUtils.isBlank((CharSequence)agentId)) {
            return new ResponseResult(20005, "The parameter 'agentId' is required");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("agentId", agentId);
        return this.doRequest("/v3/agent/delete.json", GsonUtil.toJson(params, Map.class), method, ResponseResult.class, "application/json");
    }

    public PagingQueryAgentsResult query(Integer page, Integer size, String status, String type) throws Exception {
        String method = "agentList";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (page != null) {
            params.put("page", page);
        }
        if (size != null) {
            params.put("size", size);
        }
        if (status != null) {
            params.put("status", status);
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            params.put("type", type);
        }
        return this.doRequest("/v3/agent/query.json", GsonUtil.toJson(params, Map.class), method, PagingQueryAgentsResult.class, "application/json");
    }

    public ChatAgentResult chat(ChatModel model) throws Exception {
        String method = "agentChat";
        ChatAgentResult result = this.checkFiled(model, method, ChatAgentResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/chat/generate.json", model.toString(), method, ChatAgentResult.class, "application/json");
    }
}

