/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.conversation;

import io.rong.methods.BaseMethod;
import io.rong.models.Result;
import io.rong.models.conversation.ConversationAttrModel;
import io.rong.models.conversation.ConversationModel;
import io.rong.models.conversation.ConversationSetTopModel;
import io.rong.models.conversation.ConversationTagModel;
import io.rong.models.conversation.TagConversationsModel;
import io.rong.models.conversation.UserConversationTagModel;
import io.rong.models.response.ConversationNotificationResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.response.ResultData;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Conversation
extends BaseMethod {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "conversation";
    private static final Integer PARAM_ERROR = 1002;
    private static final String ERR_REQUIRED_TEMPLATE = "The parameter %s is required.";

    @Override
    protected void initPath() {
        this.path = PATH;
    }

    public Conversation(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.initPath();
    }

    public ResponseResult mute(ConversationModel conversation) throws Exception {
        String message = CommonUtil.checkFiled(conversation, PATH, "mute");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&conversationType=").append(URLEncoder.encode(conversation.type.toString(), UTF8));
        sb.append("&requestId=").append(URLEncoder.encode(conversation.userId.toString(), UTF8));
        sb.append("&targetId=").append(URLEncoder.encode(conversation.targetId.toString(), UTF8));
        sb.append("&isMuted=").append(URLEncoder.encode("1", UTF8));
        if (conversation.busChannel != null) {
            sb.append("&busChannel=").append(URLEncoder.encode(conversation.getBusChannel(), UTF8));
        }
        sb.append("&unpushLevel=").append(URLEncoder.encode(String.valueOf(conversation.getUnpushLevel()), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/conversation/notification/set.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "mute", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult unMute(ConversationModel conversation) throws Exception {
        String message = CommonUtil.checkFiled(conversation, PATH, "unmute");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&conversationType=").append(URLEncoder.encode(conversation.type.toString(), UTF8));
        sb.append("&requestId=").append(URLEncoder.encode(conversation.userId.toString(), UTF8));
        sb.append("&targetId=").append(URLEncoder.encode(conversation.targetId.toString(), UTF8));
        sb.append("&isMuted=").append(URLEncoder.encode("0", UTF8));
        if (conversation.busChannel != null) {
            sb.append("&busChannel=").append(URLEncoder.encode(conversation.getBusChannel(), UTF8));
        }
        sb.append("&unpushLevel=").append(URLEncoder.encode("0", UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/conversation/notification/set.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "unmute", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result get(ConversationModel conversation) throws Exception {
        String body;
        String message = CommonUtil.checkFiled(conversation, PATH, "get");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&conversationType=").append(URLEncoder.encode(conversation.type, UTF8));
        sb.append("&requestId=").append(URLEncoder.encode(conversation.userId, UTF8));
        sb.append("&targetId=").append(URLEncoder.encode(conversation.targetId, UTF8));
        if (conversation.busChannel != null) {
            sb.append("&busChannel=").append(URLEncoder.encode(conversation.getBusChannel(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/conversation/notification/get.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ConversationNotificationResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ConversationNotificationResult.class);
    }

    public ResponseResult setTop(ConversationSetTopModel model) throws Exception {
        String method = "setTop";
        ResponseResult result = this.checkFiled(model, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", model.getUserId());
        this.addFormParam(sb, "&conversationType=", model.getConversationType());
        this.addFormParam(sb, "&targetId=", model.getTargetId());
        this.addFormParam(sb, "&setTop=", model.getSetTop());
        String body = sb.toString();
        return this.doRequest("/conversation/top/set.json", body, method, ResponseResult.class);
    }

    private ResponseResult required(String fieldName) {
        return new ResponseResult(PARAM_ERROR, String.format(ERR_REQUIRED_TEMPLATE, fieldName));
    }

    public ResponseResult setUserConversationTag(UserConversationTagModel model) throws Exception {
        if (model == null) {
            return this.required("model");
        }
        if (StringUtils.isBlank((CharSequence)model.getUserId())) {
            return this.required("userId");
        }
        if (model.getTags() == null || model.getTags().isEmpty()) {
            return this.required("tags");
        }
        ArrayList<ConversationTagModel> createTagList = new ArrayList<ConversationTagModel>();
        for (ConversationTagModel tag : model.getTags()) {
            if (StringUtils.isBlank((CharSequence)tag.getTagId())) {
                return this.required("tagId");
            }
            if (StringUtils.isBlank((CharSequence)tag.getTagName())) {
                return this.required("tagName");
            }
            createTagList.add(new ConversationTagModel(tag.getTagId(), tag.getTagName()));
        }
        UserConversationTagModel param = new UserConversationTagModel(model.getUserId(), createTagList);
        return this.doRequest("/user/conversation/tag/set.json", GsonUtil.toJson(param, UserConversationTagModel.class), "", ResponseResult.class, "application/json");
    }

    public ResponseResult deleteUserConversationTag(String userId, List<String> tagIds) throws Exception {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return this.required("userId");
        }
        if (tagIds == null || tagIds.isEmpty()) {
            return this.required("tagIds");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userId", userId);
        param.put("tagIds", tagIds);
        return this.doRequest("/user/conversation/tag/del.json", GsonUtil.toJson(param, Map.class), "", ResponseResult.class, "application/json");
    }

    public ResultData<UserConversationTagModel> queryUserConversationTags(String userId) throws Exception {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return new ResultData<UserConversationTagModel>(PARAM_ERROR, String.format(ERR_REQUIRED_TEMPLATE, "userId"));
        }
        String uri = "/user/conversation/tag/get.json?userId=" + URLEncoder.encode(userId, UTF8);
        return this.doGetRequest(uri, ResultData.class);
    }

    public ResponseResult setConversationTag(TagConversationsModel tagConversations) throws Exception {
        return this.setOrDeleteConversationTag(tagConversations, false);
    }

    public ResponseResult removeConversationTag(TagConversationsModel tagConversations) throws Exception {
        return this.setOrDeleteConversationTag(tagConversations, true);
    }

    private ResponseResult setOrDeleteConversationTag(TagConversationsModel tagConversations, boolean delete) throws Exception {
        if (tagConversations == null) {
            return this.required("tagConversations");
        }
        if (StringUtils.isBlank((CharSequence)tagConversations.getUserId())) {
            return this.required("userId");
        }
        if (StringUtils.isBlank((CharSequence)tagConversations.getTagId())) {
            return this.required("tagId");
        }
        if (tagConversations.getConversations() == null || tagConversations.getConversations().isEmpty()) {
            return this.required("conversations");
        }
        for (TagConversationsModel.Conversation conversation : tagConversations.getConversations()) {
            if (StringUtils.isBlank((CharSequence)conversation.getTargetId())) {
                return this.required("targetId");
            }
            if (conversation.getConversationType() != null) continue;
            return this.required("conversationType");
        }
        String uri = delete ? "/tag/conversation/del.json" : "/tag/conversation/set.json";
        return this.doRequest(uri, GsonUtil.toJson(tagConversations, TagConversationsModel.class), "", ResponseResult.class, "application/json");
    }

    public ResultData<TagConversationsModel> queryTagConversations(String userId, String tagId) throws Exception {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return new ResultData<TagConversationsModel>(PARAM_ERROR, String.format(ERR_REQUIRED_TEMPLATE, "userId"));
        }
        if (StringUtils.isBlank((CharSequence)tagId)) {
            return new ResultData<TagConversationsModel>(PARAM_ERROR, String.format(ERR_REQUIRED_TEMPLATE, "tagId"));
        }
        String uri = "/tag/conversation/get.json?userId=" + URLEncoder.encode(userId, UTF8) + "&tagId=" + URLEncoder.encode(tagId, UTF8);
        return this.doGetRequest(uri, ResultData.class);
    }

    public ResultData<ConversationAttrModel> queryConversationAttribute(String userId, String targetId, Integer conversationType) throws Exception {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return new ResultData<ConversationAttrModel>(PARAM_ERROR, String.format(ERR_REQUIRED_TEMPLATE, "userId"));
        }
        if (StringUtils.isBlank((CharSequence)targetId)) {
            return new ResultData<ConversationAttrModel>(PARAM_ERROR, String.format(ERR_REQUIRED_TEMPLATE, "targetId"));
        }
        if (conversationType == null) {
            return new ResultData<ConversationAttrModel>(PARAM_ERROR, String.format(ERR_REQUIRED_TEMPLATE, "conversationType"));
        }
        String uri = "/conversation/attribute/get.json?userId=" + URLEncoder.encode(userId, UTF8) + "&targetId=" + URLEncoder.encode(targetId, UTF8) + "&conversationType=" + conversationType;
        return this.doGetRequest(uri, ResultData.class);
    }
}

