/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.group.remark;

import io.rong.RongCloud;
import io.rong.models.response.GroupRemarkModel;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;

public class Remark {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "group/remark";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Remark(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public ResponseResult set(String userId, String groupId, String remark) throws Exception {
        String message = CommonUtil.checkParam("id", groupId, PATH, "set");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=" + userId);
        sb.append("&groupId=" + groupId);
        sb.append("&remark=" + remark);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/remarks/set.json");
        HttpUtil.setBodyParameter(sb.toString(), conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "set", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult del(String userId, String groupId) throws Exception {
        String message = CommonUtil.checkParam("id", userId, PATH, "set");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=" + userId);
        sb.append("&groupId=" + groupId);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/remarks/del.json");
        HttpUtil.setBodyParameter(sb.toString(), conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "del", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public GroupRemarkModel get(String userId, String groupId) throws Exception {
        String message = CommonUtil.checkParam("id", groupId, PATH, "set");
        if (null != message) {
            return (GroupRemarkModel)GsonUtil.fromJson(message, GroupRemarkModel.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=" + userId);
        sb.append("&groupId=" + groupId);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/remarks/get.json");
        HttpUtil.setBodyParameter(sb.toString(), conn, this.rongCloud.getConfig());
        return (GroupRemarkModel)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), GroupRemarkModel.class);
    }
}

