/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.message.history;

import io.rong.methods.BaseMethod;
import io.rong.models.Result;
import io.rong.models.history.QueryHistoryMessageModel;
import io.rong.models.response.HistoryMessageResult;
import io.rong.models.response.QueryHistoryMessageResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class History
extends BaseMethod {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "message/history";

    @Override
    protected void initPath() {
        this.path = PATH;
    }

    public History(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.initPath();
    }

    public Result get(String date) throws Exception {
        if (date == null) {
            return new ResponseResult(1002, "Paramer 'date' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&date=").append(URLEncoder.encode(date.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/history.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (HistoryMessageResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), HistoryMessageResult.class);
    }

    public ResponseResult remove(String date) throws Exception {
        if (date == null) {
            return new ResponseResult(1002, "Paramer 'date' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&date=").append(URLEncoder.encode(date.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/history/delete.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult clean(String conversationType, String fromUserId, String targetId, String msgTimestamp) throws Exception {
        String body;
        if (StringUtils.isBlank((CharSequence)conversationType) || StringUtils.isBlank((CharSequence)fromUserId) || StringUtils.isBlank((CharSequence)targetId)) {
            return new ResponseResult(1002, "Paramer 'conversationType', 'fromUserId', 'targetId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&conversationType=").append(URLEncoder.encode(conversationType, UTF8));
        sb.append("&fromUserId=").append(URLEncoder.encode(fromUserId, UTF8));
        sb.append("&targetId=").append(URLEncoder.encode(targetId, UTF8));
        if (StringUtils.isNotBlank((CharSequence)msgTimestamp)) {
            sb.append("&msgTimestamp=").append(URLEncoder.encode(msgTimestamp, UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/conversation/message/history/clean.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "clean", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public QueryHistoryMessageResult queryPrivateHistoryMessage(QueryHistoryMessageModel model) throws Exception {
        String method = "qryHisMsg";
        QueryHistoryMessageResult result = this.checkFiled(model, method, QueryHistoryMessageResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/message/private/query.json", model.toString(), method, QueryHistoryMessageResult.class, "application/json");
    }

    public QueryHistoryMessageResult queryGroupHistoryMessage(QueryHistoryMessageModel model) throws Exception {
        String method = "qryHisMsg";
        QueryHistoryMessageResult result = this.checkFiled(model, method, QueryHistoryMessageResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/message/group/query.json", model.toString(), method, QueryHistoryMessageResult.class, "application/json");
    }

    public QueryHistoryMessageResult queryUltraGroupHistoryMessage(QueryHistoryMessageModel model) throws Exception {
        String method = "qryHisMsg";
        QueryHistoryMessageResult result = this.checkFiled(model, method, QueryHistoryMessageResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/message/ultragroup/query.json", model.toString(), method, QueryHistoryMessageResult.class, "application/json");
    }

    public QueryHistoryMessageResult queryChatroomHistoryMessage(QueryHistoryMessageModel model) throws Exception {
        String method = "qryHisMsg";
        QueryHistoryMessageResult result = this.checkFiled(model, method, QueryHistoryMessageResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/message/chatroom/query.json", model.toString(), method, QueryHistoryMessageResult.class, "application/json");
    }
}

