/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.profile;

import io.rong.RongCloud;
import io.rong.methods.BaseMethod;
import io.rong.models.profile.CreateEntrustGroupModel;
import io.rong.models.profile.EntrustGroupModel;
import io.rong.models.profile.GroupRemarkNameModel;
import io.rong.models.profile.ImportEntrustGroupModel;
import io.rong.models.profile.KickOutEntrustGroupModel;
import io.rong.models.profile.MemberInfoModel;
import io.rong.models.profile.PageModel;
import io.rong.models.profile.PagingQueryMembersModel;
import io.rong.models.profile.QueryJoinedGroupsModel;
import io.rong.models.profile.QuitEntrustGroupModel;
import io.rong.models.profile.TransferOwnerModel;
import io.rong.models.response.FollowedMemberResult;
import io.rong.models.response.JoinGroupResult;
import io.rong.models.response.PagingQueryGroupsResult;
import io.rong.models.response.PagingQueryJoinedGroupsResult;
import io.rong.models.response.PagingQueryMembersResult;
import io.rong.models.response.QueryGroupProfilesResult;
import io.rong.models.response.QueryMembersResult;
import io.rong.models.response.RemarkNameResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.response.SetManagersResult;
import org.apache.commons.lang3.StringUtils;

public class EntrustGroup
extends BaseMethod {
    private static final String API_JSON_PATH = "profile/group";

    public EntrustGroup(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
        this.initPath();
    }

    @Override
    protected void initPath() {
        this.path = API_JSON_PATH;
    }

    public ResponseResult create(CreateEntrustGroupModel group) throws Exception {
        String method = "create";
        ResponseResult result = this.checkFiled(group, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", group.getGroupId());
        this.addFormParam(sb, "&name=", group.getName());
        this.addFormParam(sb, "&owner=", group.getOwner());
        this.addFormParam(sb, "&userIds=", StringUtils.join((Object[])this.removeDuplicates(group.getUserIds()), (String)","));
        this.addFormParam(sb, "&groupProfile=", group.getGroupProfile());
        this.addFormParam(sb, "&groupExtProfile=", group.getGroupExtProfile());
        this.addFormParam(sb, "&permissions=", group.getPermissions());
        String body = sb.toString();
        return this.doRequest("/entrust/group/create.json", body, method, ResponseResult.class);
    }

    public ResponseResult updateProfile(EntrustGroupModel group) throws Exception {
        String method = "update";
        ResponseResult result = this.checkFiled(group, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", group.getGroupId());
        this.addFormParam(sb, "&name=", group.getName());
        this.addFormParam(sb, "&groupProfile=", group.getGroupProfile());
        this.addFormParam(sb, "&groupExtProfile=", group.getGroupExtProfile());
        this.addFormParam(sb, "&permissions=", group.getPermissions());
        String body = sb.toString();
        return this.doRequest("/entrust/group/profile/update.json", body, method, ResponseResult.class);
    }

    public QueryGroupProfilesResult queryProfiles(String ... groupIds) throws Exception {
        String method = "queryProfile";
        QueryGroupProfilesResult result = this.checkParam("groupIds", groupIds, method, QueryGroupProfilesResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupIds=", StringUtils.join((Object[])this.removeDuplicates(groupIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/entrust/group/profile/query.json", body, method, QueryGroupProfilesResult.class);
    }

    public ResponseResult quit(QuitEntrustGroupModel params) throws Exception {
        String method = "quit";
        ResponseResult result = this.checkFiled(params, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", params.getGroupId());
        this.addFormParam(sb, "&userIds=", StringUtils.join((Object[])this.removeDuplicates(params.getUserIds()), (String)","));
        this.addFormParam(sb, "&isDelBan=", params.getIsDelBan());
        this.addFormParam(sb, "&isDelWhite=", params.getIsDelWhite());
        this.addFormParam(sb, "&isDelFollowed=", params.getIsDelFollowed());
        String body = sb.toString();
        return this.doRequest("/entrust/group/quit.json", body, method, ResponseResult.class);
    }

    public ResponseResult kickOut(KickOutEntrustGroupModel params) throws Exception {
        String method = "kick";
        ResponseResult result = this.checkFiled(params, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", params.getGroupId());
        this.addFormParam(sb, "&userIds=", StringUtils.join((Object[])this.removeDuplicates(params.getUserIds()), (String)","));
        this.addFormParam(sb, "&isDelBan=", params.getIsDelBan());
        this.addFormParam(sb, "&isDelWhite=", params.getIsDelWhite());
        this.addFormParam(sb, "&isDelFollowed=", params.getIsDelFollowed());
        String body = sb.toString();
        return this.doRequest("/entrust/group/member/kick.json", body, method, ResponseResult.class);
    }

    public ResponseResult kickOutAllGroups(String userId) throws Exception {
        String method = "kickAll";
        ResponseResult result = this.checkParam("userId", userId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        String body = sb.toString();
        return this.doRequest("/entrust/group/member/kick/all.json", body, method, ResponseResult.class);
    }

    public ResponseResult dismiss(String groupId) throws Exception {
        String method = "dismiss";
        ResponseResult result = this.checkParam("groupId", groupId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", groupId);
        String body = sb.toString();
        return this.doRequest("/entrust/group/dismiss.json", body, method, ResponseResult.class);
    }

    public JoinGroupResult join(String groupId, String ... userIds) throws Exception {
        String method = "join";
        JoinGroupResult result = this.checkParam("groupId", groupId, method, JoinGroupResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userIds", userIds, method, JoinGroupResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", groupId);
        this.addFormParam(sb, "&userIds=", StringUtils.join((Object[])this.removeDuplicates(userIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/entrust/group/join.json", body, method, JoinGroupResult.class);
    }

    public ResponseResult transferOwner(TransferOwnerModel params) throws Exception {
        String method = "tansOwner";
        ResponseResult result = this.checkFiled(params, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", params.getGroupId());
        this.addFormParam(sb, "&newOwner=", params.getNewOwner());
        this.addFormParam(sb, "&isDelBan=", params.getIsDelBan());
        this.addFormParam(sb, "&isDelWhite=", params.getIsDelWhite());
        this.addFormParam(sb, "&isDelFollowed=", params.getIsDelFollowed());
        this.addFormParam(sb, "&isQuit=", params.getIsQuit());
        String body = sb.toString();
        return this.doRequest("/entrust/group/transfer/owner.json", body, method, ResponseResult.class);
    }

    public ResponseResult importGroup(ImportEntrustGroupModel group) throws Exception {
        String method = "import";
        ResponseResult result = this.checkFiled(group, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", group.getGroupId());
        this.addFormParam(sb, "&name=", group.getName());
        this.addFormParam(sb, "&owner=", group.getOwner());
        this.addFormParam(sb, "&groupProfile=", group.getGroupProfile());
        this.addFormParam(sb, "&groupExtProfile=", group.getGroupExtProfile());
        this.addFormParam(sb, "&permissions=", group.getPermissions());
        String body = sb.toString();
        return this.doRequest("/entrust/group/import.json", body, method, ResponseResult.class);
    }

    public SetManagersResult addManagers(String groupId, String ... userIds) throws Exception {
        String method = "groupManager";
        SetManagersResult result = this.checkParam("groupId", groupId, method, SetManagersResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userIds", userIds, method, SetManagersResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", groupId);
        this.addFormParam(sb, "&userIds=", StringUtils.join((Object[])this.removeDuplicates(userIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/entrust/group/manager/add.json", body, method, SetManagersResult.class);
    }

    public ResponseResult removeManagers(String groupId, String ... userIds) throws Exception {
        String method = "groupManager";
        ResponseResult result = this.checkParam("groupId", groupId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userIds", userIds, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", groupId);
        this.addFormParam(sb, "&userIds=", StringUtils.join((Object[])this.removeDuplicates(userIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/entrust/group/manager/remove.json", body, method, ResponseResult.class);
    }

    public PagingQueryMembersResult pagingQueryMembers(PagingQueryMembersModel pageQuery) throws Exception {
        String method = "pagingQueryMembers";
        PagingQueryMembersResult result = this.checkFiled(pageQuery, method, PagingQueryMembersResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", pageQuery.getGroupId());
        this.addFormParam(sb, "&type=", pageQuery.getType());
        this.addFormParam(sb, "&pageToken=", pageQuery.getPageToken());
        this.addFormParam(sb, "&size=", pageQuery.getSize());
        this.addFormParam(sb, "&order=", pageQuery.getOrder());
        String body = sb.toString();
        return this.doRequest("/entrust/group/member/query.json", body, method, PagingQueryMembersResult.class);
    }

    public QueryMembersResult queryMembersByUserIds(String groupId, String ... userIds) throws Exception {
        String method = "queryMembers";
        QueryMembersResult result = this.checkParam("groupId", groupId, method, QueryMembersResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userIds", userIds, method, QueryMembersResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", groupId);
        this.addFormParam(sb, "&userIds=", StringUtils.join((Object[])this.removeDuplicates(userIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/entrust/group/member/specific/query.json", body, method, QueryMembersResult.class);
    }

    public ResponseResult setMemberInfo(MemberInfoModel memberInfoModel) throws Exception {
        String method = "setMember";
        ResponseResult result = this.checkFiled(memberInfoModel, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "groupId=", memberInfoModel.getGroupId());
        this.addFormParam(sb, "&userId=", memberInfoModel.getUserId());
        this.addFormParam(sb, "&nickname=", memberInfoModel.getNickname());
        this.addFormParam(sb, "&extra=", memberInfoModel.getExtra());
        String body = sb.toString();
        return this.doRequest("/entrust/group/member/set.json", body, method, ResponseResult.class);
    }

    public ResponseResult setRemarkName(GroupRemarkNameModel goupRemarkNameModel) throws Exception {
        String method = "setRemarkName";
        ResponseResult result = this.checkFiled(goupRemarkNameModel, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", goupRemarkNameModel.getUserId());
        this.addFormParam(sb, "&groupId=", goupRemarkNameModel.getGroupId());
        this.addFormParam(sb, "&remarkName=", goupRemarkNameModel.getRemarkName());
        String body = sb.toString();
        return this.doRequest("/entrust/group/remarkname/set.json", body, method, ResponseResult.class);
    }

    public ResponseResult delRemarkName(String groupId, String userId) throws Exception {
        String method = "delRemarkName";
        ResponseResult result = this.checkParam("groupId", groupId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userId", userId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        this.addFormParam(sb, "&groupId=", groupId);
        String body = sb.toString();
        return this.doRequest("/entrust/group/remarkname/delete.json", body, method, ResponseResult.class);
    }

    public RemarkNameResult queryRemarkName(String groupId, String userId) throws Exception {
        String method = "queryRemarkName";
        RemarkNameResult result = this.checkParam("groupId", groupId, method, RemarkNameResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userId", userId, method, RemarkNameResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        this.addFormParam(sb, "&groupId=", groupId);
        String body = sb.toString();
        return this.doRequest("/entrust/group/remarkname/query.json", body, method, RemarkNameResult.class);
    }

    public ResponseResult followMember(String groupId, String userId, String ... followUserIds) throws Exception {
        String method = "follow";
        ResponseResult result = this.checkParam("groupId", groupId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userId", userId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("followUserIds", followUserIds, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        this.addFormParam(sb, "&groupId=", groupId);
        this.addFormParam(sb, "&followUserIds=", StringUtils.join((Object[])this.removeDuplicates(followUserIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/entrust/group/member/follow.json", body, method, ResponseResult.class);
    }

    public ResponseResult unfollowMember(String groupId, String userId, String ... followUserIds) throws Exception {
        String method = "unfollow";
        ResponseResult result = this.checkParam("groupId", groupId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userId", userId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("followUserIds", followUserIds, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        this.addFormParam(sb, "&groupId=", groupId);
        this.addFormParam(sb, "&followUserIds=", StringUtils.join((Object[])this.removeDuplicates(followUserIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/entrust/group/member/unfollow.json", body, method, ResponseResult.class);
    }

    public FollowedMemberResult getFollowedMember(String groupId, String userId) throws Exception {
        String method = "getFollowed";
        FollowedMemberResult result = this.checkParam("groupId", groupId, method, FollowedMemberResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("userId", userId, method, FollowedMemberResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        this.addFormParam(sb, "&groupId=", groupId);
        String body = sb.toString();
        return this.doRequest("/entrust/group/member/followed/get.json", body, method, FollowedMemberResult.class);
    }

    public PagingQueryGroupsResult pagingQueryGroups(PageModel pageModel) throws Exception {
        String method = "pagingQueryGroups";
        PagingQueryGroupsResult result = this.checkFiled(pageModel, method, PagingQueryGroupsResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "pageToken=", pageModel.getPageToken());
        this.addFormParam(sb, "&size=", pageModel.getSize());
        this.addFormParam(sb, "&order=", pageModel.getOrder());
        String body = sb.toString();
        return this.doRequest("/entrust/group/query.json", body, method, PagingQueryGroupsResult.class);
    }

    public PagingQueryJoinedGroupsResult pagingQueryJoinedGroups(QueryJoinedGroupsModel pageModel) throws Exception {
        String method = "pagingQueryJoinedGroups";
        PagingQueryJoinedGroupsResult result = this.checkFiled(pageModel, method, PagingQueryJoinedGroupsResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", pageModel.getUserId());
        this.addFormParam(sb, "&role=", pageModel.getRole());
        this.addFormParam(sb, "&pageToken=", pageModel.getPageToken());
        this.addFormParam(sb, "&size=", pageModel.getSize());
        this.addFormParam(sb, "&order=", pageModel.getOrder());
        String body = sb.toString();
        return this.doRequest("/entrust/joined/group/query.json", body, method, PagingQueryJoinedGroupsResult.class);
    }
}

