/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.profile;

import io.rong.RongCloud;
import io.rong.methods.BaseMethod;
import io.rong.models.profile.FriendModel;
import io.rong.models.profile.FriendProfileModel;
import io.rong.models.profile.PagingGetFriendsModel;
import io.rong.models.response.CheckFriendsResult;
import io.rong.models.response.GetPermissionResult;
import io.rong.models.response.QueryFriendsResult;
import io.rong.models.response.ResponseResult;
import org.apache.commons.lang3.StringUtils;

public class Friend
extends BaseMethod {
    private static final String API_JSON_PATH = "profile/friend";

    public Friend(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
        this.initPath();
    }

    @Override
    protected void initPath() {
        this.path = API_JSON_PATH;
    }

    public ResponseResult add(FriendModel friend) throws Exception {
        String method = "addFriend";
        ResponseResult result = this.checkFiled(friend, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", friend.getUserId());
        this.addFormParam(sb, "&targetId=", friend.getTargetId());
        this.addFormParam(sb, "&optType=", friend.getOptType());
        this.addFormParam(sb, "&extra=", friend.getExtra());
        String body = sb.toString();
        return this.doRequest("/friend/add.json", body, method, ResponseResult.class);
    }

    public ResponseResult delete(String userId, String ... targetIds) throws Exception {
        String method = "delFriend";
        ResponseResult result = this.checkParam("userId", userId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("targetIds", targetIds, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        this.addFormParam(sb, "&targetIds=", StringUtils.join((Object[])this.removeDuplicates(targetIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/friend/delete.json", body, method, ResponseResult.class);
    }

    public ResponseResult clean(String userId) throws Exception {
        String method = "cleanFriend";
        ResponseResult result = this.checkParam("userId", userId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        String body = sb.toString();
        return this.doRequest("/friend/clean.json", body, method, ResponseResult.class);
    }

    public ResponseResult setProfile(FriendProfileModel profileModel) throws Exception {
        String method = "setFriendProfile";
        ResponseResult result = this.checkFiled(profileModel, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", profileModel.getUserId());
        this.addFormParam(sb, "&targetId=", profileModel.getTargetId());
        this.addFormParam(sb, "&remarkName=", profileModel.getRemarkName());
        this.addFormParam(sb, "&friendExtProfile=", profileModel.getFriendExtProfile());
        String body = sb.toString();
        return this.doRequest("/friend/profile/set.json", body, method, ResponseResult.class);
    }

    public QueryFriendsResult pagingGetFriends(PagingGetFriendsModel getFriendsModel) throws Exception {
        String method = "pagingGetFriends";
        QueryFriendsResult result = this.checkFiled(getFriendsModel, method, QueryFriendsResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", getFriendsModel.getUserId());
        this.addFormParam(sb, "&pageToken=", getFriendsModel.getPageToken());
        this.addFormParam(sb, "&size=", getFriendsModel.getSize());
        this.addFormParam(sb, "&order=", getFriendsModel.getOrder());
        String body = sb.toString();
        return this.doRequest("/friend/get.json", body, method, QueryFriendsResult.class);
    }

    public CheckFriendsResult checkFriends(String userId, String ... targetIds) throws Exception {
        String method = "checkFriends";
        CheckFriendsResult result = this.checkParam("userId", userId, method, CheckFriendsResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("targetIds", targetIds, method, CheckFriendsResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        this.addFormParam(sb, "&targetIds=", StringUtils.join((Object[])this.removeDuplicates(targetIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/friend/check.json", body, method, CheckFriendsResult.class);
    }

    public ResponseResult setPermission(Integer permissionType, String ... userIds) throws Exception {
        String method = "setPerm";
        ResponseResult result = this.checkParam("userIds", userIds, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        result = this.checkParam("permissionType", permissionType, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userIds=", StringUtils.join((Object[])this.removeDuplicates(userIds), (String)","));
        this.addFormParam(sb, "&permissionType=", permissionType);
        String body = sb.toString();
        return this.doRequest("/friend/permission/set.json", body, method, ResponseResult.class);
    }

    public GetPermissionResult getPermission(String ... userIds) throws Exception {
        String method = "getPerm";
        GetPermissionResult result = this.checkParam("userIds", userIds, method, GetPermissionResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userIds=", StringUtils.join((Object[])this.removeDuplicates(userIds), (String)","));
        String body = sb.toString();
        return this.doRequest("/friend/permission/get.json", body, method, GetPermissionResult.class);
    }
}

