/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.push;

import com.alibaba.fastjson.JSONException;
import com.google.gson.JsonParseException;
import io.rong.RongCloud;
import io.rong.models.push.PushModel;
import io.rong.models.response.PushResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;

public class PushCustom {
    private static final String PATH = "push/custom";
    private static final String URI = "/push/custom.json";
    private static final String CONTENT_TYPE = "application/json";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public PushCustom(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public PushResult pushcustom(PushModel push) throws Exception {
        String message = CommonUtil.checkFiled(push, PATH, "pushcustom");
        if (null != message) {
            return (PushResult)GsonUtil.fromJson(message, PushResult.class);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, URI, CONTENT_TYPE);
        HttpUtil.setBodyParameter(push.toString(), conn, this.rongCloud.getConfig());
        PushResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (PushResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "pushcustom", response), PushResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new PushResult(500, "");
            result.setErrorMessage("request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(push.toString());
        return result;
    }
}

