/*
 * Decompiled with CFR 0.152.
 */
package io.rong.models.message;

import io.rong.messages.BaseMessage;
import io.rong.models.message.PushExt;
import io.rong.util.GsonUtil;

public class MessageModel {
    private String senderId;
    private String[] targetId;
    private String objectName;
    private BaseMessage content;
    private String pushContent;
    private String pushData;
    private String pushExt;
    private Long msgRandom;
    private Boolean disableUpdateLastMsg;

    public MessageModel() {
    }

    public MessageModel(String senderId, String[] targetId, String objectName, BaseMessage content, String pushContent, String pushData) {
        this.senderId = senderId;
        this.targetId = targetId;
        this.objectName = objectName;
        this.content = content;
        this.pushContent = pushContent;
        this.pushData = pushData;
        this.pushExt = null;
    }

    public MessageModel(String senderId, String[] targetId, String objectName, BaseMessage content, String pushContent, String pushData, String pushExt) {
        this.senderId = senderId;
        this.targetId = targetId;
        this.objectName = objectName;
        this.content = content;
        this.pushContent = pushContent;
        this.pushData = pushData;
        this.pushExt = pushExt;
    }

    public String[] getTargetId() {
        return this.targetId;
    }

    public MessageModel setTargetId(String[] targetId) {
        this.targetId = targetId;
        return this;
    }

    public String getObjectName() {
        return this.objectName;
    }

    @Deprecated
    public MessageModel setObjectName(String objectName) {
        this.objectName = objectName;
        return this;
    }

    public BaseMessage getContent() {
        return this.content;
    }

    public MessageModel setContent(BaseMessage content) {
        this.content = content;
        return this;
    }

    public String getPushContent() {
        return this.pushContent;
    }

    public MessageModel setPushContent(String pushContent) {
        this.pushContent = pushContent;
        return this;
    }

    public String getPushData() {
        return this.pushData;
    }

    public MessageModel setPushData(String pushData) {
        this.pushData = pushData;
        return this;
    }

    public String getPushExt() {
        return this.pushExt;
    }

    public MessageModel setPushExt(String pushExt) {
        this.pushExt = pushExt;
        return this;
    }

    public MessageModel setPushExt(PushExt pe) {
        this.pushExt = GsonUtil.toJson(pe, PushExt.class);
        return this;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public MessageModel setSenderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    public Long getMsgRandom() {
        return this.msgRandom;
    }

    public MessageModel setMsgRandom(Long msgRandom) {
        this.msgRandom = msgRandom;
        return this;
    }

    public Boolean getDisableUpdateLastMsg() {
        return this.disableUpdateLastMsg;
    }

    public MessageModel setDisableUpdateLastMsg(Boolean disableUpdateLastMsg) {
        this.disableUpdateLastMsg = disableUpdateLastMsg;
        return this;
    }
}

