/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EndNode
extends BaseNode {
    private boolean normal = true;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isNormal() {
        return this.normal;
    }

    public void setNormal(boolean normal) {
        this.normal = normal;
    }

    public EndNode() {
        this.name = "end";
    }

    @Override
    public Map<String, Object> execute(Chain chain) {
        if (StringUtil.hasText(this.message)) {
            if (this.normal) {
                chain.stopNormal(this.message);
            } else {
                chain.stopError(this.message);
            }
        }
        if (this.outputDefs != null) {
            HashMap<String, Object> output = new HashMap<String, Object>();
            for (Parameter outputDef : this.outputDefs) {
                if (outputDef.getRefType() == RefType.REF) {
                    output.put(outputDef.getName(), chain.get(outputDef.getRef()));
                    continue;
                }
                if (outputDef.getRefType() == RefType.INPUT) {
                    output.put(outputDef.getName(), outputDef.getRef());
                    continue;
                }
                if (!StringUtil.hasText(outputDef.getRef())) continue;
                output.put(outputDef.getName(), chain.get(outputDef.getRef()));
            }
            return output;
        }
        return Collections.emptyMap();
    }

    public String toString() {
        return "EndNode{normal=" + this.normal + ", message='" + this.message + '\'' + ", description='" + this.description + '\'' + ", parameters=" + this.parameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", async=" + this.async + ", inwardEdges=" + this.inwardEdges + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + (Object)((Object)this.nodeStatus) + '}';
    }
}

