/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.document.loader;

import com.agentsflex.core.document.DocumentParser;
import com.agentsflex.core.document.loader.AbstractDocumentLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpDocumentLoader
extends AbstractDocumentLoader {
    private String url;
    private Map<String, String> headers;
    private final OkHttpClient okHttpClient;

    public HttpDocumentLoader(DocumentParser documentParser, String url) {
        super(documentParser);
        this.url = url;
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
    }

    public HttpDocumentLoader(DocumentParser documentParser, String url, Map<String, String> headers) {
        super(documentParser);
        this.url = url;
        this.headers = headers;
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream loadInputStream() {
        Request.Builder builder = new Request.Builder().url(this.url);
        if (this.headers != null && !this.headers.isEmpty()) {
            this.headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        Request request = builder.get().build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            ResponseBody body = response.body();
            if (body == null) return null;
            InputStream inputStream = body.byteStream();
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

