/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client.impl;

import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.OkHttpClientUtil;
import com.agentsflex.core.llm.client.impl.Util;
import com.agentsflex.core.util.LogUtil;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

public class WebSocketClient
extends WebSocketListener
implements LlmClient {
    private WebSocket webSocket;
    private LlmClientListener listener;
    private LlmConfig config;
    private boolean isStop = false;
    private String payload;

    @Override
    public void start(String url, Map<String, String> headers, String payload, LlmClientListener listener, LlmConfig config) {
        this.listener = listener;
        this.payload = payload;
        this.config = config;
        OkHttpClient client = OkHttpClientUtil.buildDefaultClient();
        Request request = new Request.Builder().url(url).build();
        this.isStop = false;
        this.webSocket = client.newWebSocket(request, (WebSocketListener)this);
        if (this.config.isDebug()) {
            LogUtil.println(">>>>send payload:" + payload);
        }
    }

    @Override
    public void stop() {
        try {
            this.tryToStop();
        }
        finally {
            this.tryToCloseWebSocket();
        }
    }

    public void onOpen(WebSocket webSocket, Response response) {
        webSocket.send(this.payload);
        this.listener.onStart(this);
    }

    public void onMessage(WebSocket webSocket, String text) {
        if (this.config.isDebug()) {
            LogUtil.println(">>>>receive payload:" + text);
        }
        this.listener.onMessage(this, text);
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.onMessage(webSocket, bytes.utf8());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosing(WebSocket webSocket, int code, String reason) {
        try {
            this.tryToStop();
        }
        finally {
            this.tryToCloseWebSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        try {
            try {
                Throwable failureThrowable = Util.getFailureThrowable(t, response);
                this.listener.onFailure(this, failureThrowable);
            }
            finally {
                this.tryToStop();
            }
        }
        finally {
            this.tryToCloseWebSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        try {
            this.tryToStop();
        }
        finally {
            this.tryToCloseWebSocket();
        }
    }

    private void tryToCloseWebSocket() {
        if (this.webSocket != null) {
            this.webSocket.close(1000, "");
            this.webSocket = null;
        }
    }

    private boolean tryToStop() {
        if (!this.isStop) {
            this.isStop = true;
            this.listener.onStop(this);
            return true;
        }
        return false;
    }
}

