/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.store.condition;

import com.agentsflex.core.store.condition.ConditionType;
import com.agentsflex.core.store.condition.Connector;
import com.agentsflex.core.store.condition.ExpressionAdaptor;
import com.agentsflex.core.store.condition.Operand;
import com.agentsflex.core.store.condition.Value;

public class Condition
implements Operand {
    protected ConditionType type;
    protected Operand left;
    protected Operand right;
    protected boolean effective = true;
    protected Connector connector;
    protected Condition prev;
    protected Condition next;

    public Condition() {
    }

    public Condition(ConditionType type, Operand left, Operand right) {
        this.type = type;
        this.left = left;
        this.right = right;
        if (left instanceof Value) {
            ((Value)left).setCondition(this);
        }
        if (right instanceof Value) {
            ((Value)right).setCondition(this);
        }
    }

    public void connect(Condition nextCondition, Connector connector) {
        if (this.next != null) {
            this.next.connect(nextCondition, connector);
        } else {
            nextCondition.connector = connector;
            this.next = nextCondition;
            nextCondition.prev = this;
        }
    }

    public boolean checkEffective() {
        return this.effective;
    }

    protected Condition getPrevEffectiveCondition() {
        if (this.prev == null) {
            return null;
        }
        return this.prev.checkEffective() ? this.prev : this.prev.getPrevEffectiveCondition();
    }

    protected Condition getNextEffectiveCondition() {
        if (this.next == null) {
            return null;
        }
        return this.next.checkEffective() ? this.next : this.next.getNextEffectiveCondition();
    }

    @Override
    public String toExpression(ExpressionAdaptor adaptor) {
        StringBuilder expr = new StringBuilder();
        if (this.checkEffective()) {
            Condition prevEffectiveCondition = this.getPrevEffectiveCondition();
            if (prevEffectiveCondition != null && this.connector != null) {
                expr.append(adaptor.toConnector(this.connector));
            }
            expr.append(adaptor.toCondition(this));
        }
        if (this.next != null) {
            expr.append(this.next.toExpression(adaptor));
        }
        return expr.toString();
    }

    public ConditionType getType() {
        return this.type;
    }

    public void setType(ConditionType type) {
        this.type = type;
    }

    public Operand getLeft() {
        return this.left;
    }

    public void setLeft(Operand left) {
        this.left = left;
    }

    public Operand getRight() {
        return this.right;
    }

    public void setRight(Operand right) {
        this.right = right;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public void setEffective(boolean effective) {
        this.effective = effective;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Condition getPrev() {
        return this.prev;
    }

    public void setPrev(Condition prev) {
        this.prev = prev;
    }

    public Condition getNext() {
        return this.next;
    }

    public void setNext(Condition next) {
        this.next = next;
    }

    public String toString() {
        return "Condition{type=" + (Object)((Object)this.type) + ", left=" + this.left + ", right=" + this.right + ", effective=" + this.effective + ", connector=" + (Object)((Object)this.connector) + ", prev=" + this.prev + ", next=" + this.next + '}';
    }
}

