/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.RefType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Parameter
implements Serializable,
Cloneable {
    protected String id;
    protected String name;
    protected String description;
    protected DataType dataType = DataType.String;
    protected String ref;
    protected RefType refType;
    protected String value;
    protected boolean required;
    protected String defaultValue;
    protected List<Parameter> children;

    public Parameter() {
    }

    public Parameter(String name) {
        this.name = name;
    }

    public Parameter(String name, DataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    public Parameter(String name, boolean required) {
        this.name = name;
        this.required = required;
    }

    public Parameter(String name, DataType dataType, boolean required) {
        this.name = name;
        this.dataType = dataType;
        this.required = required;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public RefType getRefType() {
        return this.refType;
    }

    public void setRefType(RefType refType) {
        this.refType = refType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<Parameter> getChildren() {
        return this.children;
    }

    public void setChildren(List<Parameter> children) {
        this.children = children;
    }

    public void addChild(Parameter parameter) {
        if (this.children == null) {
            this.children = new ArrayList<Parameter>();
        }
        this.children.add(parameter);
    }

    public void addChildren(Collection<Parameter> parameters) {
        if (this.children == null) {
            this.children = new ArrayList<Parameter>();
        }
        this.children.addAll(parameters);
    }

    public String toString() {
        return "Parameter{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", ref='" + this.ref + '\'' + ", refType=" + (Object)((Object)this.refType) + ", value='" + this.value + '\'' + ", required=" + this.required + ", children=" + this.children + '}';
    }

    public Parameter clone() {
        try {
            Parameter clone = (Parameter)super.clone();
            if (this.children != null) {
                clone.children = new ArrayList<Parameter>(this.children.size());
                for (Parameter child : this.children) {
                    clone.children.add(child.clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

