/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainSuspendException;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.node.BaseNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ConfirmNode
extends BaseNode {
    private String randomUUID = UUID.randomUUID().toString();
    private String message;
    private List<ConfirmParameter> confirms;

    public String getRandomUUID() {
        return this.randomUUID;
    }

    public void setRandomUUID(String randomUUID) {
        this.randomUUID = randomUUID;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<ConfirmParameter> getConfirms() {
        return this.confirms;
    }

    public void setConfirms(List<ConfirmParameter> confirms) {
        if (confirms != null) {
            for (ConfirmParameter confirm : confirms) {
                confirm.setRefType(RefType.INPUT);
                confirm.setName(confirm.getName());
            }
        }
        this.confirms = confirms;
    }

    @Override
    protected Map<String, Object> execute(Chain chain) {
        Map<String, Object> values;
        ArrayList<ConfirmParameter> confirmParameters = new ArrayList<ConfirmParameter>();
        this.addConfirmParameter(confirmParameters);
        if (this.confirms != null) {
            for (ConfirmParameter confirm : this.confirms) {
                ConfirmParameter clone = confirm.clone();
                clone.setName(confirm.getName() + "__" + this.randomUUID);
                clone.setRefType(RefType.INPUT);
                confirmParameters.add(clone);
            }
        }
        try {
            values = chain.getParameterValues(this, confirmParameters);
        }
        catch (ChainSuspendException e) {
            chain.setMessage(this.message);
            if (this.confirms != null) {
                ArrayList<ConfirmParameter> newParameters = new ArrayList<ConfirmParameter>();
                for (ConfirmParameter confirm : this.confirms) {
                    ConfirmParameter clone = confirm.clone();
                    clone.setName(confirm.getName() + "__" + this.randomUUID);
                    clone.setRefType(RefType.REF);
                    newParameters.add(clone);
                }
                Map<String, Object> parameterValues = chain.getParameterValues(this, newParameters, null, true);
                for (ConfirmParameter confirmParameter : confirmParameters) {
                    if (confirmParameter.getSelectionData() != null) continue;
                    confirmParameter.setSelectionDataObject(parameterValues.get(confirmParameter.getName()));
                }
            }
            throw e;
        }
        HashMap<String, Object> results = new HashMap<String, Object>(values.size());
        values.forEach((key, value) -> {
            int index = key.lastIndexOf("__");
            if (index >= 0) {
                results.put(key.substring(0, index), value);
            } else {
                results.put((String)key, value);
            }
        });
        return results;
    }

    private void addConfirmParameter(List<ConfirmParameter> parameters) {
        ConfirmParameter parameter = new ConfirmParameter();
        parameter.setRefType(RefType.INPUT);
        parameter.setId("confirm");
        parameter.setName("confirm__" + this.randomUUID);
        parameter.setRequired(true);
        ArrayList<Object> selectionData = new ArrayList<Object>();
        selectionData.add("yes");
        selectionData.add("no");
        parameter.setSelectionData(selectionData);
        parameter.setSelectionDataType("text");
        parameter.setSelectionMode("confirm");
        parameters.add(parameter);
    }

    public static class ConfirmParameter
    extends Parameter
    implements Cloneable {
        protected List<Object> selectionData;
        protected String formLabel;
        protected String formDescription;
        protected String selectionDataType;
        protected String selectionMode;

        public List<Object> getSelectionData() {
            return this.selectionData;
        }

        public void setSelectionData(List<Object> selectionData) {
            this.selectionData = selectionData;
        }

        public void setSelectionDataObject(Object selectionData) {
            if (selectionData == null) {
                this.selectionData = null;
            } else if (selectionData instanceof Collection) {
                this.selectionData = new ArrayList<Object>();
                this.selectionData.addAll((Collection)selectionData);
            } else if (selectionData.getClass().isArray()) {
                this.selectionData = new ArrayList<Object>();
                this.selectionData.addAll(Arrays.asList((Object[])selectionData));
            } else {
                this.selectionData = new ArrayList<Object>(1);
                this.selectionData.add(selectionData);
            }
        }

        public String getFormLabel() {
            return this.formLabel;
        }

        public void setFormLabel(String formLabel) {
            this.formLabel = formLabel;
        }

        public String getFormDescription() {
            return this.formDescription;
        }

        public void setFormDescription(String formDescription) {
            this.formDescription = formDescription;
        }

        public String getSelectionDataType() {
            return this.selectionDataType;
        }

        public void setSelectionDataType(String selectionDataType) {
            this.selectionDataType = selectionDataType;
        }

        public String getSelectionMode() {
            return this.selectionMode;
        }

        public void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public String toString() {
            return "ConfirmParameter{selectionData=" + this.selectionData + ", formLabel='" + this.formLabel + '\'' + ", formDescription='" + this.formDescription + '\'' + ", selectionDataType='" + this.selectionDataType + '\'' + ", selectionMode='" + this.selectionMode + '\'' + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", ref='" + this.ref + '\'' + ", refType=" + (Object)((Object)this.refType) + ", value='" + this.value + '\'' + ", required=" + this.required + ", defaultValue='" + this.defaultValue + '\'' + ", children=" + this.children + '}';
        }

        @Override
        public ConfirmParameter clone() {
            return (ConfirmParameter)super.clone();
        }
    }
}

