/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.openai;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.FunctionMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.parser.impl.DefaultFunctionMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.agentsflex.llm.openai.OpenAiLlmConfig;
import com.alibaba.fastjson.JSON;

public class OpenAiLLmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat();

    public static AiMessageParser getAiMessageParser(boolean isStream) {
        DefaultAiMessageParser aiMessageParser = new DefaultAiMessageParser();
        if (isStream) {
            aiMessageParser.setContentPath("$.choices[0].delta.content");
        } else {
            aiMessageParser.setContentPath("$.choices[0].message.content");
        }
        aiMessageParser.setIndexPath("$.choices[0].index");
        aiMessageParser.setStatusPath("$.choices[0].finish_reason");
        aiMessageParser.setStatusParser(content -> OpenAiLLmUtil.parseMessageStatus((String)content));
        aiMessageParser.setTotalTokensPath("$.usage.total_tokens");
        aiMessageParser.setPromptTokensPath("$.usage.prompt_tokens");
        aiMessageParser.setCompletionTokensPath("$.usage.completion_tokens");
        return aiMessageParser;
    }

    public static FunctionMessageParser getFunctionMessageParser() {
        DefaultFunctionMessageParser functionMessageParser = new DefaultFunctionMessageParser();
        functionMessageParser.setFunctionNamePath("$.choices[0].message.tool_calls[0].function.name");
        functionMessageParser.setFunctionArgsPath("$.choices[0].message.tool_calls[0].function.arguments");
        functionMessageParser.setFunctionArgsParser(JSON::parseObject);
        return functionMessageParser;
    }

    public static MessageStatus parseMessageStatus(String status) {
        return "stop".equals(status) ? MessageStatus.END : MessageStatus.MIDDLE;
    }

    public static String promptToEmbeddingsPayload(Document text, EmbeddingOptions options, OpenAiLlmConfig config) {
        return Maps.of((String)"model", (Object)options.getModelOrDefault(config.getDefaultEmbeddingModel())).put("encoding_format", (Object)"float").put("input", (Object)text.getContent()).toJSON();
    }

    public static String promptToPayload(Prompt<?> prompt, OpenAiLlmConfig config, ChatOptions options, boolean withStream) {
        Maps.Builder builder = Maps.of((String)"model", (Object)config.getModel()).put("messages", promptFormat.toMessagesJsonObject(prompt)).putIf(withStream, "stream", (Object)true).putIfNotEmpty("tools", promptFormat.toFunctionsJsonObject(prompt)).putIfContainsKey("tools", "tool_choice", (Object)"auto").putIfNotNull("top_p", (Object)options.getTopP()).putIfNotEmpty("stop", (Object)options.getStop()).putIf(map -> !map.containsKey("tools") && options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).putIf(map -> !map.containsKey("tools") && options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens());
        return JSON.toJSONString((Object)builder.build());
    }
}

