/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.qwen;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.FunctionMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.parser.impl.DefaultFunctionMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.agentsflex.llm.qwen.QwenLlmConfig;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;

public class QwenLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat();

    public static AiMessageParser getAiMessageParser() {
        DefaultAiMessageParser aiMessageParser = new DefaultAiMessageParser();
        aiMessageParser.setContentPath("$.output.choices[0].message.content");
        aiMessageParser.setStatusPath("$.output.choices[0].finish_reason");
        aiMessageParser.setTotalTokensPath("$.usage.total_tokens");
        aiMessageParser.setStatusParser(content -> QwenLlmUtil.parseMessageStatus((String)content));
        aiMessageParser.setTotalTokensPath("$.usage.total_tokens");
        aiMessageParser.setPromptTokensPath("$.usage.input_tokens");
        aiMessageParser.setCompletionTokensPath("$.usage.output_tokens");
        return aiMessageParser;
    }

    public static FunctionMessageParser getFunctionMessageParser() {
        DefaultFunctionMessageParser functionMessageParser = new DefaultFunctionMessageParser();
        functionMessageParser.setFunctionNamePath("$.output.choices[0].message.tool_calls[0].function.name");
        functionMessageParser.setFunctionArgsPath("$.output.choices[0].message.tool_calls[0].function.arguments");
        functionMessageParser.setFunctionArgsParser(JSON::parseObject);
        return functionMessageParser;
    }

    public static MessageStatus parseMessageStatus(String status) {
        return "stop".equals(status) ? MessageStatus.END : MessageStatus.MIDDLE;
    }

    public static String promptToPayload(Prompt<?> prompt, QwenLlmConfig config, ChatOptions options) {
        Maps.Builder root = Maps.of((String)"model", (Object)config.getModel()).put("input", Maps.of((String)"messages", (Object)promptFormat.toMessagesJsonObject(prompt))).put("parameters", Maps.of((String)"result_format", (Object)"message").putIfNotEmpty("tools", promptFormat.toFunctionsJsonObject(prompt)).putIf(map -> !map.containsKey("tools") && options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).putIf(map -> !map.containsKey("tools") && options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens()).putIfNotNull("top_p", (Object)options.getTopP()).putIfNotNull("top_k", (Object)options.getTopK()).putIfNotEmpty("stop", (Object)options.getStop()));
        return JSON.toJSONString((Object)root.build());
    }

    public static String promptToEnabledPayload(Document text, EmbeddingOptions options, QwenLlmConfig config) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(text.getContent());
        Maps.Builder root = Maps.of((String)"model", (Object)config.getModel()).put("input", Maps.of((String)"texts", list));
        return JSON.toJSONString((Object)root.build());
    }

    public static String createEmbedURL(QwenLlmConfig config) {
        return "https://dashscope.aliyuncs.com/api/v1/services/embeddings/text-embedding/text-embedding";
    }
}

